/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.inventory.ModuleItemContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class ModuleItem
extends Item {
    private static final MutableComponent MODIFIABLE = new TranslatableComponent("tooltip.securitycraft:module.modifiable").m_6270_(Utils.GRAY_STYLE);
    private static final MutableComponent NOT_MODIFIABLE = new TranslatableComponent("tooltip.securitycraft:module.notModifiable").m_6270_(Utils.GRAY_STYLE);
    public static final int MAX_PLAYERS = 50;
    private final ModuleType module;
    private final boolean containsCustomData;
    private final boolean canBeCustomized;

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData) {
        this(properties, module, containsCustomData, false);
    }

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData, boolean canBeCustomized) {
        super(properties);
        this.module = module;
        this.containsCustomData = containsCustomData;
        this.canBeCustomized = canBeCustomized;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity blockEntity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (blockEntity instanceof IModuleInventory) {
            IOwnable ownable;
            IModuleInventory inv = (IModuleInventory)blockEntity;
            ItemStack stack = ctx.m_43722_();
            ModuleType type = ((ModuleItem)stack.m_41720_()).getModuleType();
            if (inv instanceof IOwnable && !(ownable = (IOwnable)((Object)inv)).getOwner().isOwner(ctx.m_43723_())) {
                return InteractionResult.PASS;
            }
            if (inv.getAcceptedModules().contains((Object)type) && !inv.hasModule(type)) {
                inv.insertModule(stack);
                inv.onModuleInserted(stack, type);
                if (!ctx.m_43723_().m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.canBeCustomized()) {
            if (this.module == ModuleType.ALLOWLIST || this.module == ModuleType.DENYLIST) {
                if (level.f_46443_) {
                    ClientHandler.displayEditModuleGui(stack);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (this.module == ModuleType.DISGUISE) {
                if (!level.f_46443_) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new DisguiseModuleMenu(windowId, inv, new ModuleItemContainer(player.m_21120_(hand)));
                        }

                        public Component m_5446_() {
                            return new TranslatableComponent(ModuleItem.this.m_5524_());
                        }
                    });
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        Block addon;
        if (this.containsCustomData || this.canBeCustomized()) {
            list.add((Component)MODIFIABLE);
        } else {
            list.add((Component)NOT_MODIFIABLE);
        }
        if (this.canBeCustomized() && (addon = this.getBlockAddon(stack.m_41783_())) != null) {
            list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.added", Utils.localize(addon.m_7705_(), new Object[0])).m_6270_(Utils.GRAY_STYLE));
        }
    }

    public ModuleType getModuleType() {
        return this.module;
    }

    public Block getBlockAddon(CompoundTag tag) {
        Item item;
        if (tag == null) {
            return null;
        }
        ListTag items = tag.m_128437_("ItemInventory", 10);
        if (items != null && !items.isEmpty() && (item = ItemStack.m_41712_((CompoundTag)items.m_128728_(0)).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_();
        }
        return null;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

