/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class CameraMonitorItem
extends Item {
    public CameraMonitorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onItemUse(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43722_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_);
    }

    public InteractionResult onItemUse(Player player, Level level, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        if (level.m_8055_(pos).m_60734_() == SCContent.SECURITY_CAMERA.get() && !PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)level.m_7702_(pos);
            if (!be.getOwner().isOwner(player) && !ModuleUtils.isAllowed((IModuleInventory)be, (Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:cameraMonitor.cannotView", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
            if (stack.m_41783_() == null) {
                stack.m_41751_(new CompoundTag());
            }
            GlobalPos view = GlobalPos.m_122643_((ResourceKey)player.f_19853_.m_46472_(), (BlockPos)pos);
            if (this.isCameraAdded(stack.m_41783_(), view)) {
                stack.m_41783_().m_128473_(CameraMonitorItem.getTagNameFromPosition(stack.m_41783_(), view));
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:cameraMonitor.unbound", Utils.getFormattedCoordinates(pos)), ChatFormatting.RED);
                return InteractionResult.SUCCESS;
            }
            for (int i = 1; i <= 30; ++i) {
                if (stack.m_41783_().m_128441_("Camera" + i)) continue;
                stack.m_41783_().m_128359_("Camera" + i, LevelUtils.toNBTString(view));
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:cameraMonitor.bound", Utils.getFormattedCoordinates(pos)), ChatFormatting.GREEN);
                break;
            }
            if (!level.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41782_() || !this.hasCameraAdded(stack.m_41783_())) {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), ChatFormatting.RED);
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (stack.m_41720_() == SCContent.CAMERA_MONITOR.get() && level.f_46443_) {
            ClientHandler.displayCameraMonitorGui(player.m_150109_(), (CameraMonitorItem)stack.m_41720_(), stack.m_41783_());
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41783_() == null) {
            return;
        }
        tooltip.add((Component)Utils.localize("tooltip.securitycraft:cameraMonitor", new Object[0]).m_7220_((Component)new TextComponent(" " + this.getNumberOfCamerasBound(stack.m_41783_()) + "/30")).m_6270_(Utils.GRAY_STYLE));
    }

    public static String getTagNameFromPosition(CompoundTag tag, GlobalPos view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.m_128441_("Camera" + i) || !LevelUtils.checkCoordinates(view, coords = tag.m_128461_("Camera" + i).split(" "))) continue;
            return "Camera" + i;
        }
        return "";
    }

    public boolean hasCameraAdded(CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 30; ++i) {
            if (!tag.m_128441_("Camera" + i)) continue;
            return true;
        }
        return false;
    }

    public boolean isCameraAdded(CompoundTag tag, GlobalPos view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.m_128441_("Camera" + i) || !LevelUtils.checkCoordinates(view, coords = tag.m_128461_("Camera" + i).split(" "))) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GlobalPos> getCameraPositions(CompoundTag tag) {
        ArrayList<GlobalPos> list = new ArrayList<GlobalPos>();
        for (int i = 1; i <= 30; ++i) {
            if (tag != null && tag.m_128441_("Camera" + i)) {
                String[] coords = tag.m_128461_("Camera" + i).split(" ");
                list.add(GlobalPos.m_122643_((ResourceKey)(coords.length == 4 ? ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(coords[3])) : Level.f_46428_), (BlockPos)new BlockPos(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]))));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    public int getNumberOfCamerasBound(CompoundTag tag) {
        if (tag == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 1; i <= 31; ++i) {
            if (!tag.m_128441_("Camera" + i)) continue;
            ++amount;
        }
        return amount;
    }
}

