/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.fluids;

import java.util.Random;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class FakeLavaFluid
extends FlowingFluid {
    public Fluid m_5615_() {
        return (Fluid)SCContent.FLOWING_FAKE_LAVA.get();
    }

    public Fluid m_5613_() {
        return (Fluid)SCContent.FAKE_LAVA.get();
    }

    public Item m_6859_() {
        return (Item)SCContent.FAKE_LAVA_BUCKET.get();
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)new ResourceLocation("block/lava_still"), (ResourceLocation)new ResourceLocation("block/lava_flow")).translationKey("block.minecraft.lava").luminosity(15).density(3000).viscosity(6000).temperature(1300).build((Fluid)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7450_(Level level, BlockPos pos, FluidState state, Random random) {
        BlockPos posAbove = pos.m_7494_();
        if (level.m_8055_(posAbove).m_60795_() && !level.m_8055_(posAbove).m_60804_((BlockGetter)level, posAbove)) {
            if (random.nextInt(100) == 0) {
                double x = (float)pos.m_123341_() + random.nextFloat();
                double y = pos.m_123342_() + 1;
                double z = (float)pos.m_123343_() + random.nextFloat();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 0.0, 0.0, 0.0);
                level.m_7785_(x, y, z, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public void m_7449_(Level level, BlockPos pos, FluidState state, Random random) {
        block7: {
            if (!level.m_46469_().m_46207_(GameRules.f_46131_)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos posToUpdate = pos;
                for (int j = 0; j < i; ++j) {
                    if (!level.m_46749_(posToUpdate = posToUpdate.m_142082_(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState stateToUpdate = level.m_8055_(posToUpdate);
                    if (stateToUpdate.m_60795_()) {
                        if (!this.isSurroundingBlockFlammable(level, posToUpdate)) continue;
                        level.m_46597_(posToUpdate, Blocks.f_50083_.m_49966_());
                        return;
                    }
                    if (!stateToUpdate.m_60767_().m_76334_()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos posToUpdate = pos.m_142082_(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!level.m_46749_(posToUpdate)) {
                        return;
                    }
                    if (!level.m_46859_(posToUpdate.m_7494_()) || !this.getCanBlockBurn(level, posToUpdate)) continue;
                    level.m_46597_(posToUpdate.m_7494_(), Blocks.f_50083_.m_49966_());
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(Level level, BlockPos pos) {
        for (Direction Direction2 : Direction.values()) {
            if (!this.getCanBlockBurn(level, pos.m_142300_(Direction2))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(Level level, BlockPos pos) {
        return !level.m_46749_(pos) ? false : level.m_8055_(pos).m_60767_().m_76335_();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ParticleOptions m_7792_() {
        return ParticleTypes.f_123800_;
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        this.triggerEffects(level, pos);
    }

    public int m_6719_(LevelReader level) {
        return level.m_6042_().m_63951_() ? 4 : 2;
    }

    public BlockState m_5804_(FluidState state) {
        return (BlockState)((Block)SCContent.FAKE_LAVA_BLOCK.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(FakeLavaFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == SCContent.FAKE_LAVA.get() || fluid == SCContent.FLOWING_FAKE_LAVA.get();
    }

    public int m_6713_(LevelReader level) {
        return level.m_6042_().m_63951_() ? 1 : 2;
    }

    public boolean m_5486_(FluidState fluidState, BlockGetter level, BlockPos pos, Fluid fluid, Direction dir) {
        return fluidState.m_76155_(level, pos) >= 0.44444445f && fluid.m_76108_((Tag)FluidTags.f_13131_);
    }

    public int m_6718_(LevelReader level) {
        return level.m_6042_().m_63951_() ? 10 : 30;
    }

    public int m_6886_(Level level, BlockPos pos, FluidState fluidState1, FluidState fluidState2) {
        int tickDelay = this.m_6718_((LevelReader)level);
        if (!(fluidState1.m_76178_() || fluidState2.m_76178_() || ((Boolean)fluidState1.m_61143_((Property)f_75947_)).booleanValue() || ((Boolean)fluidState2.m_61143_((Property)f_75947_)).booleanValue() || !(fluidState2.m_76155_((BlockGetter)level, pos) > fluidState1.m_76155_((BlockGetter)level, pos)) || level.m_5822_().nextInt(4) == 0)) {
            tickDelay *= 4;
        }
        return tickDelay;
    }

    protected void triggerEffects(LevelAccessor level, BlockPos pos) {
        level.m_46796_(1501, pos, 0);
    }

    protected boolean m_6760_() {
        return false;
    }

    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN && this.m_76108_((Tag)FluidTags.f_13132_) && fluidState.m_76153_((Tag)FluidTags.f_13131_)) {
            if (state.m_60734_() instanceof LiquidBlock) {
                level.m_7731_(pos, Blocks.f_50069_.m_49966_(), 3);
            }
            this.triggerEffects(level, pos);
            return;
        }
        super.m_6364_(level, pos, state, direction, fluidState);
    }

    protected boolean m_6685_() {
        return true;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public static class Source
    extends FakeLavaFluid {
        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FakeLavaFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

