/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class CameraController {
    public static CameraType previousCameraType;
    private static ClientChunkCache.Storage cameraStorage;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        if (cameraEntity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)cameraEntity;
            Options options = Minecraft.m_91087_().f_91066_;
            if (event.phase == TickEvent.Phase.START) {
                wasUpPressed = options.f_92085_.m_90857_();
                if (wasUpPressed) {
                    options.f_92085_.m_7249_(false);
                }
                if (wasDownPressed = options.f_92087_.m_90857_()) {
                    options.f_92087_.m_7249_(false);
                }
                if (wasLeftPressed = options.f_92086_.m_90857_()) {
                    options.f_92086_.m_7249_(false);
                }
                if (wasRightPressed = options.f_92088_.m_90857_()) {
                    options.f_92088_.m_7249_(false);
                }
                if (options.f_92090_.m_90857_()) {
                    CameraController.dismount();
                    options.f_92090_.m_7249_(false);
                }
            } else if (event.phase == TickEvent.Phase.END) {
                if (wasUpPressed) {
                    CameraController.moveViewUp(cam);
                    options.f_92085_.m_7249_(true);
                }
                if (wasDownPressed) {
                    CameraController.moveViewDown(cam);
                    options.f_92087_.m_7249_(true);
                }
                if (wasLeftPressed) {
                    CameraController.moveViewHorizontally(cam, cam.m_146908_(), cam.m_146908_() - (float)cam.cameraSpeed * cam.zoomAmount);
                    options.f_92086_.m_7249_(true);
                }
                if (wasRightPressed) {
                    CameraController.moveViewHorizontally(cam, cam.m_146908_(), cam.m_146908_() + (float)cam.cameraSpeed * cam.zoomAmount);
                    options.f_92088_.m_7249_(true);
                }
                if (KeyBindings.cameraZoomIn.m_90857_()) {
                    CameraController.zoomIn(cam);
                } else if (KeyBindings.cameraZoomOut.m_90857_()) {
                    CameraController.zoomOut(cam);
                } else {
                    cam.zooming = false;
                }
                if (KeyBindings.cameraEmitRedstone.m_90859_()) {
                    CameraController.emitRedstone(cam);
                }
                if (KeyBindings.cameraActivateNightVision.m_90859_()) {
                    CameraController.giveNightVision(cam);
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                double yRotChange = player.m_146908_() - player.f_108598_;
                double xRotChange = player.m_146909_() - player.f_108599_;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(player.m_146908_(), player.m_146909_(), player.m_20096_()));
                }
            }
        }
    }

    private static void dismount() {
        SecurityCraft.channel.sendToServer((Object)new DismountCamera());
    }

    public static void moveViewUp(SecurityCamera cam) {
        float next = cam.m_146909_() - (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next > -25.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewDown(SecurityCamera cam) {
        float next = cam.m_146909_() + (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next < 60.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewHorizontally(SecurityCamera cam, float yRot, float next) {
        BlockState state = cam.f_19853_.m_8055_(cam.m_142538_());
        if (state.m_61138_((Property)SecurityCameraBlock.FACING)) {
            boolean shouldSetRotation;
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            switch ((Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) {
                case NORTH: {
                    boolean bl;
                    if (checkNext > 90.0f && checkNext < 270.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case SOUTH: {
                    boolean bl;
                    if (checkNext > 270.0f || checkNext < 90.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case EAST: {
                    boolean bl;
                    if (checkNext > 180.0f && checkNext < 360.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case WEST: {
                    boolean bl;
                    if (checkNext > 0.0f && checkNext < 180.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case DOWN: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.m_146922_(next);
            }
        }
    }

    public static void zoomIn(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.m_91087_().f_91073_.m_104677_(cam.m_142538_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.max(cam.zoomAmount - 0.1f, 0.1f);
    }

    public static void zoomOut(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.m_91087_().f_91073_.m_104677_(cam.m_142538_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.min(cam.zoomAmount + 0.1f, 1.4f);
    }

    public static void emitRedstone(SecurityCamera cam) {
        if (cam.redstoneCooldown == 0) {
            cam.toggleRedstonePower();
            cam.redstoneCooldown = 30;
        }
    }

    public static void giveNightVision(SecurityCamera cam) {
        if (cam.toggleNightVisionCooldown == 0) {
            cam.toggleNightVision();
        }
    }

    public static ClientChunkCache.Storage getCameraStorage() {
        return cameraStorage;
    }

    public static void setCameraStorage(ClientChunkCache.Storage cameraStorage) {
        if (cameraStorage != null) {
            CameraController.cameraStorage = cameraStorage;
        }
    }

    public static void setRenderPosition(Entity entity) {
        if (entity instanceof SecurityCamera) {
            SectionPos cameraPos = SectionPos.m_123194_((Entity)entity);
            CameraController.cameraStorage.f_104469_ = cameraPos.m_123170_();
            CameraController.cameraStorage.f_104470_ = cameraPos.m_123222_();
        }
    }
}

