/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class IMSBomb
extends Fireball {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.m_135353_(IMSBomb.class, Owner.getSerializer());
    private int ticksFlying = 0;
    private int launchTime;
    private boolean launching = true;
    private boolean isFast;

    public IMSBomb(EntityType<IMSBomb> type, Level level) {
        super(SCContent.eTypeImsBomb, level);
    }

    public IMSBomb(Level level, double x, double y, double z, double accelerationX, double accelerationY, double accelerationZ, int height, IMSBlockEntity be) {
        super(SCContent.eTypeImsBomb, x, y, z, accelerationX, accelerationY, accelerationZ, level);
        Owner owner = be.getOwner();
        this.launchTime = height * 3;
        this.f_19804_.m_135381_(OWNER, (Object)new Owner(owner.getName(), owner.getUUID()));
        this.isFast = be.hasModule(ModuleType.SPEED);
    }

    public void m_8119_() {
        if (!this.launching) {
            super.m_8119_();
        } else {
            if (this.ticksFlying == 0) {
                this.m_20334_(this.m_20184_().f_82479_, this.isFast ? (double)0.66f : (double)0.33f, this.m_20184_().f_82481_);
            }
            if (this.ticksFlying < this.launchTime) {
                this.ticksFlying += this.isFast ? 2 : 1;
                this.m_6478_(MoverType.SELF, this.m_20184_());
            } else {
                this.m_20334_(0.0, 0.0, 0.0);
                this.launching = false;
            }
        }
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_ && result.m_6662_() == HitResult.Type.BLOCK && this.f_19853_.m_8055_(((BlockHitResult)result).m_82425_()).m_60734_() != SCContent.IMS.get()) {
            BlockPos impactPos = ((BlockHitResult)result).m_82425_();
            this.f_19853_.m_46518_((Entity)this, (double)impactPos.m_123341_(), (double)impactPos.m_123342_() + 1.0, (double)impactPos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.5f : 7.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
            this.m_146870_();
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("launchTime", this.launchTime);
        tag.m_128405_("ticksFlying", this.ticksFlying);
        tag.m_128379_("launching", this.launching);
        tag.m_128379_("isFast", this.isFast);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.launchTime = tag.m_128451_("launchTime");
        this.ticksFlying = tag.m_128451_("ticksFlying");
        this.launching = tag.m_128471_("launching");
        this.isFast = tag.m_128471_("isFast");
    }

    public Owner getSCOwner() {
        return (Owner)this.f_19804_.m_135370_(OWNER);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER, (Object)new Owner());
    }

    protected float m_6884_() {
        return this.isFast ? 1.5f : 1.0f;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return false;
    }

    public float m_6143_() {
        return 0.3f;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

