/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WitherRoseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BaseReinforcedBlock
extends OwnableBlock
implements IReinforcedBlock {
    private final Supplier<Block> vanillaBlockSupplier;

    public BaseReinforcedBlock(BlockBehaviour.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public BaseReinforcedBlock(BlockBehaviour.Properties properties, Supplier<Block> vB) {
        super(properties);
        this.vanillaBlockSupplier = vB;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(level, pos.m_142300_(facing));
        PlantType type = plantable.getPlantType(level, pos.m_142300_(facing));
        if (super.canSustainPlant(state, level, pos, facing, plantable)) {
            return true;
        }
        if (plant.m_60734_() == Blocks.f_50128_) {
            return state.m_60620_(SCTags.Blocks.REINFORCED_SAND);
        }
        if (plantable instanceof BushBlock) {
            if (plantable instanceof AzaleaBlock) {
                return state.m_60713_((Block)SCContent.REINFORCED_CLAY.get());
            }
            if (plantable instanceof FungusBlock || plantable instanceof NetherSproutsBlock || plantable instanceof RootsBlock) {
                return state.m_60713_((Block)SCContent.REINFORCED_SOUL_SOIL.get());
            }
            if (plantable instanceof WaterlilyBlock) {
                return level.m_6425_(pos).m_76152_() == SCContent.FAKE_WATER.get() && level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76191_;
            }
            if (plantable instanceof WitherRoseBlock) {
                return state.m_60713_((Block)SCContent.REINFORCED_NETHERRACK.get()) || state.m_60713_((Block)SCContent.REINFORCED_SOUL_SOIL.get());
            }
            if (plantable instanceof DeadBushBlock) {
                return state.m_60620_(SCTags.Blocks.REINFORCED_SAND) || state.m_60713_((Block)SCContent.REINFORCED_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_WHITE_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_ORANGE_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_MAGENTA_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_LIGHT_BLUE_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_YELLOW_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_LIME_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_PINK_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_GRAY_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_LIGHT_GRAY_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_CYAN_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_PURPLE_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_BLUE_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_BROWN_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_GREEN_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_RED_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_BLACK_TERRACOTTA.get()) || state.m_60713_((Block)SCContent.REINFORCED_DIRT.get()) || state.m_60713_((Block)SCContent.REINFORCED_COARSE_DIRT.get()) || state.m_60713_((Block)SCContent.REINFORCED_PODZOL.get());
            }
        }
        if (PlantType.DESERT.equals(type)) {
            return this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_TERRACOTTA.get();
        }
        if (PlantType.BEACH.equals(type)) {
            boolean isBeach = state.m_60620_(SCTags.Blocks.REINFORCED_SAND);
            boolean hasWater = false;
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockState blockState = level.m_8055_(pos.m_142300_(face));
                FluidState fluidState = level.m_6425_(pos.m_142300_(face));
                hasWater |= blockState.m_60713_(Blocks.f_50449_);
                if (!(hasWater |= fluidState.m_76153_((Tag)FluidTags.f_13131_))) continue;
                break;
            }
            return isBeach && hasWater;
        }
        return false;
    }

    public boolean isConduitFrame(BlockState state, LevelReader level, BlockPos pos, BlockPos conduit) {
        return this == SCContent.REINFORCED_PRISMARINE.get() || this == SCContent.REINFORCED_PRISMARINE_BRICKS.get() || this == SCContent.REINFORCED_SEA_LANTERN.get() || this == SCContent.REINFORCED_DARK_PRISMARINE.get();
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (this.getVanillaBlock() instanceof HalfTransparentBlock) {
            return adjacentBlockState.m_60734_() == this ? true : super.m_6104_(state, adjacentBlockState, side);
        }
        return false;
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlockSupplier.get();
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.m_49966_();
    }
}

