/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.entity.BouncingBetty;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class BouncingBettyBlock
extends ExplosiveBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.m_61465_((String)"deactivated");
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);

    public BouncingBettyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (!level.m_8055_(pos.m_7495_()).m_60795_()) {
            return;
        }
        if (((Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46961_(pos, true);
        } else {
            this.explode(level, pos);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.m_7495_(), Direction.UP);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!EntityUtils.doesEntityOwn(entity, level, pos)) {
            this.explode(level, pos);
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!player.m_7500_() && !EntityUtils.doesPlayerOwn(player, level, pos)) {
            this.explode(level, pos);
        }
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (level.f_46443_ || ((Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
            return;
        }
        BouncingBetty bouncingBettyEntity = new BouncingBetty(level, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
        level.m_46961_(pos, false);
        bouncingBettyEntity.fuse = 15;
        bouncingBettyEntity.m_20256_(bouncingBettyEntity.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, 0.5, 0.0));
        LevelUtils.addScheduledTask((LevelAccessor)level, () -> level.m_7967_((Entity)bouncingBettyEntity));
        bouncingBettyEntity.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.tnt.primed")), 1.0f, 1.0f);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.m_5456_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(SCContent.beTypeAbstract, pos, state);
    }
}

