/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseFullMineBlock
extends ExplosiveBlock
implements IOverlayDisplay,
IBlockMine {
    private final Block blockDisguisedAs;

    public BaseFullMineBlock(BlockBehaviour.Properties properties, Block disguisedBlock) {
        super(properties);
        this.blockDisguisedAs = disguisedBlock;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ctx;
        if (collisionContext instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext).m_193113_() != null) {
            Entity entity = ctx.m_193113_();
            if (entity instanceof ItemEntity) {
                return Shapes.m_83144_();
            }
            if (entity instanceof Player) {
                OwnableBlockEntity ownableTe;
                Player player = (Player)entity;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof OwnableBlockEntity && (ownableTe = (OwnableBlockEntity)blockEntity).getOwner().isOwner(player)) {
                    return Shapes.m_83144_();
                }
            }
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!EntityUtils.doesEntityOwn(entity, level, pos)) {
            this.explode(level, pos);
        }
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(level, pos);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.f_46443_) {
            if (player != null && player.m_7500_() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            if (!EntityUtils.doesPlayerOwn(player, level, pos)) {
                this.explode(level, pos);
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            level.m_46961_(pos, false);
            level.m_46518_(null, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 2.5f : 5.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
        }
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(SCContent.beTypeAbstract, pos, state);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return new ItemStack((ItemLike)this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        OwnableBlockEntity te;
        BlockEntity blockEntity;
        if (player.m_7500_() || (blockEntity = level.m_7702_(pos)) instanceof OwnableBlockEntity && (te = (OwnableBlockEntity)blockEntity).getOwner().isOwner(player)) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        return new ItemStack((ItemLike)this.blockDisguisedAs);
    }

    public Block getBlockDisguisedAs() {
        return this.blockDisguisedAs;
    }
}

