/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blockentities.KeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class KeypadFurnaceBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape NORTH_OPEN = Shapes.m_83148_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)2.0, (double)3.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)2.0), (VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)2.0), (BooleanOp)BooleanOp.f_82685_)), (VoxelShape)Block.m_49796_((double)1.0, (double)2.0, (double)3.0, (double)15.0, (double)15.0, (double)4.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape NORTH_CLOSED = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)3.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0), (VoxelShape)Block.m_49796_((double)5.0, (double)14.0, (double)1.0, (double)11.0, (double)15.0, (double)2.0), (BooleanOp)BooleanOp.f_82685_));
    private static final VoxelShape EAST_OPEN = Shapes.m_83148_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)13.0, (double)1.0, (double)1.0, (double)14.0, (double)2.0, (double)15.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)14.0, (double)1.0, (double)4.0, (double)16.0, (double)2.0, (double)12.0), (VoxelShape)Block.m_49796_((double)14.0, (double)1.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_)), (VoxelShape)Block.m_49796_((double)12.0, (double)2.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape EAST_CLOSED = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)13.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)14.0, (double)14.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0), (VoxelShape)Block.m_49796_((double)14.0, (double)14.0, (double)5.0, (double)15.0, (double)15.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_));
    private static final VoxelShape SOUTH_OPEN = Shapes.m_83148_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0, (double)14.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)14.0, (double)12.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_)), (VoxelShape)Block.m_49796_((double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)15.0, (double)13.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SOUTH_CLOSED = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)14.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)4.0, (double)14.0, (double)14.0, (double)12.0, (double)15.0, (double)16.0), (VoxelShape)Block.m_49796_((double)5.0, (double)14.0, (double)14.0, (double)11.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_));
    private static final VoxelShape WEST_OPEN = Shapes.m_83148_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)1.0, (double)1.0, (double)3.0, (double)2.0, (double)15.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)2.0, (double)12.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)5.0, (double)2.0, (double)2.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_)), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape WEST_CLOSED = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0)), (VoxelShape)Shapes.m_83148_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)4.0, (double)2.0, (double)15.0, (double)12.0), (VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)5.0, (double)2.0, (double)15.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_));

    public KeypadFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    yield NORTH_OPEN;
                }
                yield NORTH_CLOSED;
            }
            case Direction.EAST -> {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    yield EAST_OPEN;
                }
                yield EAST_CLOSED;
            }
            case Direction.SOUTH -> {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    yield SOUTH_OPEN;
                }
                yield SOUTH_CLOSED;
            }
            case Direction.WEST -> {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                    yield WEST_OPEN;
                }
                yield WEST_CLOSED;
            }
            default -> Shapes.m_83144_();
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof KeypadFurnaceBlock)) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            KeypadFurnaceBlockEntity be = (KeypadFurnaceBlockEntity)level.m_7702_(pos);
            if (ModuleUtils.isDenied(be, (Entity)player)) {
                if (be.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else if (ModuleUtils.isAllowed((IModuleInventory)be, (Entity)player)) {
                if (be.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                }
                this.activate(be, state, level, pos, player);
            } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand)) {
                be.openPasswordGUI(player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(KeypadFurnaceBlockEntity be, BlockState state, Level level, BlockPos pos, Player player) {
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.m_5898_((Player)null, 1006, pos, 0);
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)be, (BlockPos)pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && this.getDisguisedStateOrDefault(state, (BlockGetter)level, pos).m_60734_() != this) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Direction.Axis axis = direction.m_122434_();
            double randomNumber = rand.nextDouble() * 0.6 - 0.3;
            double xOffset = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : randomNumber;
            double yOffset = rand.nextDouble() * 6.0 / 16.0;
            double zOffset = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : randomNumber;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, LIT});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadFurnaceBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : KeypadFurnaceBlock.m_152132_(type, SCContent.beTypeKeypadFurnace, AbstractFurnaceBlockEntity::m_155013_);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static class Convertible
    implements IPasswordConvertible {
        @Override
        public Block getOriginalBlock() {
            return Blocks.f_50094_;
        }

        @Override
        public boolean convert(Player player, Level level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean lit = (Boolean)state.m_61143_((Property)LIT);
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)level.m_7702_(pos);
            CompoundTag tag = furnace.m_187480_();
            furnace.m_6211_();
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)((Block)SCContent.KEYPAD_FURNACE.get()).m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)));
            ((KeypadFurnaceBlockEntity)level.m_7702_(pos)).m_142466_(tag);
            ((IOwnable)level.m_7702_(pos)).setOwner(player.m_142081_().toString(), player.m_7755_().getString());
            return true;
        }
    }
}

