/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.KeyPanelBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeyPanelBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape FLOOR_NS = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)15.0);
    public static final VoxelShape FLOOR_EW = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)14.0);
    public static final VoxelShape CEILING_NS = Block.m_49796_((double)2.0, (double)15.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    public static final VoxelShape CEILING_EW = Block.m_49796_((double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0);
    public static final VoxelShape WALL_N = Block.m_49796_((double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0);
    public static final VoxelShape WALL_S = Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0);
    public static final VoxelShape WALL_W = Block.m_49796_((double)15.0, (double)1.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0);

    public KeyPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield FLOOR_NS;
                    }
                    case EAST: {
                        yield FLOOR_EW;
                    }
                    case SOUTH: {
                        yield FLOOR_NS;
                    }
                    case WEST: {
                        yield FLOOR_EW;
                    }
                }
                yield Shapes.m_83040_();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield CEILING_NS;
                    }
                    case EAST: {
                        yield CEILING_EW;
                    }
                    case SOUTH: {
                        yield CEILING_NS;
                    }
                    case WEST: {
                        yield CEILING_EW;
                    }
                }
                yield Shapes.m_83040_();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield WALL_N;
                    }
                    case EAST: {
                        yield WALL_E;
                    }
                    case SOUTH: {
                        yield WALL_S;
                    }
                    case WEST: {
                        yield WALL_W;
                    }
                }
                yield Shapes.m_83040_();
            }
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        KeyPanelBlockEntity be = (KeyPanelBlockEntity)level.m_7702_(pos);
        if (ModuleUtils.isDenied(be, (Entity)player)) {
            if (be.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
            }
        } else if (ModuleUtils.isAllowed((IModuleInventory)be, (Entity)player)) {
            if (be.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
            }
            this.activate(state, level, pos, be.getSignalLength());
        } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand)) {
            be.openPasswordGUI(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)this, KeyPanelBlock.getConnectedDirection(state).m_122424_());
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && KeyPanelBlock.getConnectedDirection(state) == side ? 15 : 0;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return KeyPanelBlock.canAttach(level, pos, KeyPanelBlock.getConnectedDirection(state).m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            BlockState state = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)ctx.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!state.m_60710_((LevelReader)level, pos)) continue;
            return (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return KeyPanelBlock.getConnectedDirection(state).m_122424_() == facing && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, FACE, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeyPanelBlockEntity(pos, state);
    }

    public void activate(BlockState state, Level level, BlockPos pos, int signalLength) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        BlockUtils.updateIndirectNeighbors(level, pos, (Block)this, KeyPanelBlock.getConnectedDirection(state).m_122424_());
        level.m_186460_(pos, (Block)this, signalLength);
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.m_61143_((Property)FACING);
        };
    }

    public static boolean canAttach(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.m_142300_(direction);
        return level.m_8055_(relativePos).m_60783_((BlockGetter)level, relativePos, direction.m_122424_());
    }
}

