/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.BiFunction;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InventoryScannerFieldBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.m_61465_((String)"horizontal");
    private static final VoxelShape SHAPE_EW = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_NS = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape HORIZONTAL_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public InventoryScannerFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        block4: {
            InventoryScannerBlockEntity connectedScanner;
            Level level;
            Entity entity;
            EntityCollisionContext ctx;
            block5: {
                Player player;
                if (!(collisionContext instanceof EntityCollisionContext) || (ctx = (EntityCollisionContext)collisionContext).m_193113_() == null) {
                    return Shapes.m_83040_();
                }
                entity = ctx.m_193113_();
                level = entity.m_20193_();
                connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
                if (connectedScanner == null || !connectedScanner.doesFieldSolidify()) break block4;
                if (!(entity instanceof Player) || EntityUtils.isInvisible((LivingEntity)(player = (Player)entity))) break block5;
                if (ModuleUtils.isAllowed((IModuleInventory)connectedScanner, entity)) {
                    return Shapes.m_83040_();
                }
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).m_41619_() || !InventoryScannerFieldBlock.checkInventory(player, connectedScanner, connectedScanner.getStackInSlotCopy(i), false)) continue;
                    return this.m_5940_(state, (BlockGetter)level, pos, (CollisionContext)ctx);
                }
                break block4;
            }
            if (!(entity instanceof ItemEntity)) break block4;
            ItemEntity item = (ItemEntity)entity;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i).m_41619_() || item.m_32055_().m_41619_() || !InventoryScannerFieldBlock.checkItemEntity(item, connectedScanner, connectedScanner.getStackInSlotCopy(i), false)) continue;
                return this.m_5940_(state, (BlockGetter)level, pos, (CollisionContext)ctx);
            }
        }
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        block5: {
            InventoryScannerBlockEntity connectedScanner;
            block4: {
                Player player;
                connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
                if (connectedScanner == null || connectedScanner.doesFieldSolidify()) {
                    return;
                }
                if (!(entity instanceof Player) || EntityUtils.isInvisible((LivingEntity)(player = (Player)entity))) break block4;
                if (ModuleUtils.isAllowed((IModuleInventory)connectedScanner, entity)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).m_41619_()) continue;
                    InventoryScannerFieldBlock.checkInventory(player, connectedScanner, connectedScanner.getStackInSlotCopy(i), true);
                }
                break block5;
            }
            if (!(entity instanceof ItemEntity)) break block5;
            ItemEntity item = (ItemEntity)entity;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i).m_41619_() || item.m_32055_().m_41619_()) continue;
                InventoryScannerFieldBlock.checkItemEntity(item, connectedScanner, connectedScanner.getStackInSlotCopy(i), true);
            }
        }
    }

    public static boolean checkInventory(Player player, InventoryScannerBlockEntity be, ItemStack stack, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = be.hasModule(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && be.hasModule(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && be.hasModule(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction || be.getOwner().isOwner(player)) {
            return false;
        }
        return InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.m_150109_().f_35974_, stack, be, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.m_150109_().f_35975_, stack, be, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.m_150109_().f_35976_, stack, be, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean loopInventory(NonNullList<ItemStack> inventory, ItemStack stack, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        for (int i = 1; i <= inventory.size(); ++i) {
            ItemStack itemStackChecking = (ItemStack)inventory.get(i - 1);
            if (itemStackChecking.m_41619_()) continue;
            if (InventoryScannerFieldBlock.areItemsEqual(itemStackChecking, stack, hasSmartModule)) {
                if (hasStorageModule) {
                    be.addItemToStorage((ItemStack)inventory.get(i - 1));
                    inventory.set(i - 1, (Object)ItemStack.f_41583_);
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
            if (!InventoryScannerFieldBlock.checkForShulkerBox(itemStackChecking, stack, be, hasSmartModule, hasStorageModule, hasRedstoneModule)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkItemEntity(ItemEntity entity, InventoryScannerBlockEntity be, ItemStack stack, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = be.hasModule(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && be.hasModule(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && be.hasModule(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction) {
            return false;
        }
        if (InventoryScannerFieldBlock.areItemsEqual(entity.m_32055_(), stack, hasSmartModule)) {
            if (hasStorageModule) {
                be.addItemToStorage(entity.m_32055_());
                entity.m_146870_();
            }
            if (hasRedstoneModule) {
                InventoryScannerFieldBlock.updateInventoryScannerPower(be);
            }
            return true;
        }
        return InventoryScannerFieldBlock.checkForShulkerBox(entity.m_32055_(), stack, be, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean checkForShulkerBox(ItemStack item, ItemStack stackToCheck, InventoryScannerBlockEntity be, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        if (item != null && !item.m_41619_() && item.m_41783_() != null && Block.m_49814_((Item)item.m_41720_()) instanceof ShulkerBoxBlock) {
            ListTag list = item.m_41783_().m_128469_("BlockEntityTag").m_128437_("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemInChest = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                if (!InventoryScannerFieldBlock.areItemsEqual(itemInChest, stackToCheck, hasSmartModule)) continue;
                if (hasStorageModule) {
                    be.addItemToStorage(itemInChest);
                    list.remove(i);
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(be);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean areItemsEqual(ItemStack firstItemStack, ItemStack secondItemStack, boolean hasSmartModule) {
        return hasSmartModule && InventoryScannerFieldBlock.areItemStacksEqual(firstItemStack, secondItemStack) && ItemStack.m_41658_((ItemStack)firstItemStack, (ItemStack)secondItemStack) || !hasSmartModule && firstItemStack.m_41720_() == secondItemStack.m_41720_();
    }

    private static void updateInventoryScannerPower(InventoryScannerBlockEntity be) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(be.m_58904_(), be.m_58899_());
        if (connectedScanner == null) {
            return;
        }
        InventoryScannerFieldBlock.updateInvScanner(be);
        InventoryScannerFieldBlock.updateInvScanner(connectedScanner);
    }

    private static void updateInvScanner(InventoryScannerBlockEntity be) {
        be.setShouldProvidePower(true);
        be.setCooldown(60);
        BlockUtils.updateAndNotify(be.m_58904_(), be.m_58899_(), be.m_58900_().m_60734_(), 1, true);
        BlockUtils.updateIndirectNeighbors(be.m_58904_(), be.m_58899_(), (Block)SCContent.INVENTORY_SCANNER.get());
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.m_41777_();
        ItemStack s2 = stack2.m_41777_();
        s1.m_41764_(1);
        s2.m_41764_(1);
        return ItemStack.m_41728_((ItemStack)s1, (ItemStack)s2);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            if (facing == Direction.EAST || facing == Direction.WEST) {
                this.checkAndDestroyFields(level, pos, (p, i) -> p.m_142386_(i.intValue()));
                this.checkAndDestroyFields(level, pos, (p, i) -> p.m_142385_(i.intValue()));
            } else if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                this.checkAndDestroyFields(level, pos, (p, i) -> p.m_142390_(i.intValue()));
                this.checkAndDestroyFields(level, pos, (p, i) -> p.m_142383_(i.intValue()));
            }
        }
    }

    private void checkAndDestroyFields(LevelAccessor level, BlockPos pos, BiFunction<BlockPos, Integer, BlockPos> posModifier) {
        for (int i = 0; i < (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
            BlockPos modifiedPos = posModifier.apply(pos, i);
            if (level.m_8055_(modifiedPos).m_60734_() != SCContent.INVENTORY_SCANNER.get()) continue;
            for (int j = 1; j < i; ++j) {
                level.m_46961_(posModifier.apply(pos, j), false);
            }
            break;
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (((Boolean)state.m_61143_((Property)HORIZONTAL)).booleanValue()) {
            return HORIZONTAL_SHAPE;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return SHAPE_EW;
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return SHAPE_NS;
        }
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HORIZONTAL});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(SCContent.beTypeAbstract, pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        if ((side == Direction.UP || side == Direction.DOWN) && state.m_60734_() == adjacentBlockState.m_60734_()) {
            return true;
        }
        return super.m_6104_(state, adjacentBlockState, side);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

