/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.entity.Bullet;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class TrophySystemBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
ILockable {
    public static final int RANGE = 10;
    public static final int RENDER_DISTANCE = 50;
    private final Map<EntityType<?>, Boolean> projectileFilter = new LinkedHashMap();
    public Projectile entityBeingTargeted = null;
    public int cooldown = this.getCooldownTime();
    private final Random random = new Random();

    public TrophySystemBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeTrophySystem, pos, state);
        this.projectileFilter.put(SCContent.eTypeBullet, true);
        this.projectileFilter.put(EntityType.f_20478_, true);
        this.projectileFilter.put(EntityType.f_20548_, true);
        this.projectileFilter.put(EntityType.f_20527_, true);
        this.projectileFilter.put(SCContent.eTypeImsBomb, true);
        this.projectileFilter.put(EntityType.f_20463_, true);
        this.projectileFilter.put(EntityType.f_20561_, true);
        this.projectileFilter.put(EntityType.f_20498_, true);
        this.projectileFilter.put(EntityType.f_20522_, true);
        this.projectileFilter.put(EntityType.f_20467_, true);
        this.projectileFilter.put(EntityType.f_20483_, true);
        this.projectileFilter.put(EntityType.f_20484_, true);
        this.projectileFilter.put(EntityType.f_20477_, true);
        this.projectileFilter.put(EntityType.f_20451_, true);
        this.projectileFilter.put(EntityType.f_20510_, false);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        Entity shooter;
        Projectile target;
        if (!(level.f_46443_ || this.entityBeingTargeted != null || (target = this.getPotentialTarget(level, pos)) == null || (shooter = target.m_37282_()) != null && (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && PlayerUtils.areOnSameTeam(shooter.m_7755_().getString(), this.getOwner().getName()) || shooter.m_142081_() != null && shooter.m_142081_().toString().equals(this.getOwner().getUUID()) || ModuleUtils.isAllowed((IModuleInventory)this, shooter.m_7755_().getString())))) {
            this.setTarget(target);
        }
        if (this.entityBeingTargeted == null) {
            return;
        }
        if (!this.entityBeingTargeted.m_6084_()) {
            this.resetTarget();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.destroyTarget();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(50.0);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag projectilesNBT = new CompoundTag();
        int i = 0;
        for (boolean b : this.projectileFilter.values()) {
            projectilesNBT.m_128379_("projectile" + i, b);
            ++i;
        }
        tag.m_128365_("projectiles", (Tag)projectilesNBT);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("projectiles", 10)) {
            CompoundTag projectilesNBT = tag.m_128469_("projectiles");
            int i = 0;
            for (EntityType<?> projectileType : this.projectileFilter.keySet()) {
                this.projectileFilter.put(projectileType, projectilesNBT.m_128471_("projectile" + i));
                ++i;
            }
        }
    }

    public void setTarget(Projectile target) {
        this.entityBeingTargeted = target;
        if (!this.f_58857_.f_46443_) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new SetTrophySystemTarget(this.f_58858_, target.m_142049_()));
        }
    }

    private void destroyTarget() {
        this.entityBeingTargeted.m_142687_(Entity.RemovalReason.KILLED);
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_46511_(null, this.entityBeingTargeted.m_20185_(), this.entityBeingTargeted.m_20186_(), this.entityBeingTargeted.m_20189_(), 0.1f, Explosion.BlockInteraction.NONE);
        }
        this.resetTarget();
    }

    private void resetTarget() {
        this.cooldown = this.getCooldownTime();
        this.entityBeingTargeted = null;
    }

    private Projectile getPotentialTarget(Level level, BlockPos pos) {
        List<Object> potentialTargets = new ArrayList();
        AABB area = new AABB(pos).m_82400_(10.0);
        potentialTargets.addAll(level.m_6443_(Projectile.class, area, this::isAllowedToTarget));
        potentialTargets = potentialTargets.stream().filter(this::filterSCProjectiles).collect(Collectors.toList());
        if (potentialTargets.size() <= 0) {
            return null;
        }
        int target = this.random.nextInt(potentialTargets.size());
        return (Projectile)potentialTargets.get(target);
    }

    private boolean isAllowedToTarget(Projectile target) {
        if (target instanceof ThrownTrident || target instanceof FishingHook || target instanceof ThrownPotion || target instanceof ThrownExperienceBottle) {
            return false;
        }
        return this.projectileFilter.getOrDefault(target.m_6095_(), this.projectileFilter.get(EntityType.f_20510_));
    }

    private boolean filterSCProjectiles(Projectile projectile) {
        Owner owner = null;
        if (projectile instanceof Bullet) {
            Bullet bullet = (Bullet)projectile;
            owner = bullet.getSCOwner();
        } else if (projectile instanceof IMSBomb) {
            IMSBomb imsBomb = (IMSBomb)projectile;
            owner = imsBomb.getSCOwner();
        } else {
            Entity entity = projectile.m_37282_();
            if (entity instanceof Sentry) {
                Sentry sentry = (Sentry)entity;
                owner = sentry.getOwner();
            }
        }
        return owner == null || !owner.owns(this) && !ModuleUtils.isAllowed((IModuleInventory)this, owner.getName());
    }

    public void toggleFilter(EntityType<?> projectileType) {
        this.setFilter(projectileType, this.projectileFilter.get(projectileType) == false);
    }

    public void setFilter(EntityType<?> projectileType, boolean allowed) {
        if (this.projectileFilter.containsKey(projectileType)) {
            this.projectileFilter.put(projectileType, allowed);
            if (this.f_58857_.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.SERVER.noArg(), (Object)new SyncTrophySystem(this.f_58858_, projectileType, allowed));
            }
        }
    }

    public boolean getFilter(EntityType<?> projectileType) {
        return this.projectileFilter.get(projectileType);
    }

    public Map<EntityType<?>, Boolean> getFilters() {
        return this.projectileFilter;
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.SMART) {
            for (EntityType<?> projectileType : this.projectileFilter.keySet()) {
                this.projectileFilter.put(projectileType, projectileType != EntityType.f_20510_);
            }
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.SMART, ModuleType.SPEED, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public int getCooldownTime() {
        return this.hasModule(ModuleType.SPEED) ? 4 : 8;
    }
}

