/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SpecialDoorBlockEntity
extends LinkableBlockEntity {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((SpecialDoorBlockEntity)this).m_58899_(), "signalLength", this.defaultSignalLength(), 0, 400, 5, true);

    public SpecialDoorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        this.handleModule(stack, module, false);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        this.handleModule(stack, module, true);
    }

    private void handleModule(ItemStack stack, ModuleType module, boolean removed) {
        BlockEntity blockEntity;
        DoubleBlockHalf myHalf = (DoubleBlockHalf)this.m_58900_().m_61143_((Property)DoorBlock.f_52730_);
        BlockPos otherPos = myHalf == DoubleBlockHalf.UPPER ? this.m_58899_().m_7495_() : this.m_58899_().m_7494_();
        BlockState other = this.f_58857_.m_8055_(otherPos);
        if (other.m_61143_((Property)DoorBlock.f_52730_) != myHalf && (blockEntity = this.f_58857_.m_7702_(otherPos)) instanceof SpecialDoorBlockEntity) {
            SpecialDoorBlockEntity otherDoorBe = (SpecialDoorBlockEntity)blockEntity;
            if (!removed && !otherDoorBe.hasModule(module)) {
                otherDoorBe.insertModule(stack);
            } else if (removed && otherDoorBe.hasModule(module)) {
                otherDoorBe.removeModule(module);
            }
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedBEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            if (option.getName().equals(this.sendMessage.getName())) {
                this.sendMessage.copy(option);
            } else if (option.getName().equals(this.signalLength.getName())) {
                this.signalLength.copy(option);
            }
        }
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public abstract int defaultSignalLength();
}

