/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SecurityCameraBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    public double cameraRotation = 0.0;
    public boolean addToRotation = true;
    public boolean down = false;
    public boolean downSet = false;
    public float lastPitch = Float.MAX_VALUE;
    public float lastYaw = Float.MAX_VALUE;
    private int playersViewing = 0;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).m_58899_(), "rotationSpeed", 0.018, 0.01, 0.025, 0.001, true);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).m_58899_(), "customRotation", this.cameraRotation, 1.55, -1.55, (Double)this.rotationSpeedOption.get(), true);

    public SecurityCameraBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeSecurityCamera, pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.downSet) {
            this.down = state.m_61143_((Property)SecurityCameraBlock.FACING) == Direction.DOWN;
            this.downSet = true;
        }
        if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
            this.cameraRotation = (Double)this.customRotationOption.get();
            return;
        }
        if (this.addToRotation && this.cameraRotation <= (double)1.55f) {
            this.cameraRotation += ((Double)this.rotationSpeedOption.get()).doubleValue();
        } else {
            this.addToRotation = false;
        }
        if (!this.addToRotation && this.cameraRotation >= (double)-1.55f) {
            this.cameraRotation -= ((Double)this.rotationSpeedOption.get()).doubleValue();
        } else {
            this.addToRotation = true;
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128350_("LastPitch", this.lastPitch);
        tag.m_128350_("LastYaw", this.lastYaw);
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lastPitch = tag.m_128457_("LastPitch");
        this.lastYaw = tag.m_128457_("LastYaw");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption};
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.REDSTONE) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void startViewing() {
        if (this.playersViewing++ == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void stopViewing() {
        if (--this.playersViewing == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
        }
    }
}

