/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SecretSignBlockEntity
extends SignBlockEntity
implements IOwnable,
IModuleInventory,
ICustomizable {
    private Owner owner = new Owner();
    private Option.BooleanOption isSecret = new Option.BooleanOption("isSecret", true);
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);

    public SecretSignBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> m_58903_() {
        return SCContent.beTypeSecretSign;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            this.owner.save(tag, false);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.owner.load(tag);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isSecret};
    }

    public boolean isSecret() {
        return (Boolean)this.isSecret.get();
    }

    public boolean isPlayerAllowedToSeeText(Player player) {
        return !this.isSecret() || this.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)this, (Entity)player);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public ClientboundBlockEntityDataPacket m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }
}

