/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.network.PacketDistributor;

public class LaserBlockBlockEntity
extends LinkableBlockEntity {
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.toggleLaser(this);
        }
    };

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeLaserBlock, pos, state);
    }

    private void toggleLaser(Option.BooleanOption option) {
        if (((Boolean)option.get()).booleanValue()) {
            ((LaserBlock)this.m_58900_().m_60734_()).setLaser(this.f_58857_, this.f_58858_);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedBEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.BooleanOption)option);
            excludedBEs.add(this);
            this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedBEs);
        } else if (action == LinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            excludedBEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_INSERTED, parameters, excludedBEs);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            ModuleType module = (ModuleType)((Object)parameters[1]);
            this.removeModule(module);
            excludedBEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, parameters, excludedBEs);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (!this.f_58857_.f_46443_ && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, true, stack));
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (!this.f_58857_.f_46443_ && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, false, stack));
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_BLOCK_RL, (Object)this.m_58900_().m_60734_().getRegistryName()).build();
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

