/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.KeypadFurnaceBlock;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.KeypadFurnaceMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class KeypadFurnaceBlockEntity
extends AbstractFurnaceBlockEntity
implements IPasswordProtected,
MenuProvider,
IOwnable,
INameSetter,
IModuleInventory,
ICustomizable,
ILockable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private Owner owner = new Owner();
    private String passcode;
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);

    public KeypadFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeKeypadFurnace, pos, state, RecipeType.f_44108_);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            this.owner.save(tag, false);
        }
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.owner.load(tag);
        this.passcode = tag.m_128461_("passcode");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return BlockUtils.getProtectedCapability(side, (BlockEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.f_58310_.get(slot);
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeypadFurnaceBlock) {
            KeypadFurnaceBlock block2 = (KeypadFurnaceBlock)block;
            block2.activate(this, this.m_58900_(), this.f_58857_, this.f_58858_, player);
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeCheckPassword, windowId, KeypadFurnaceBlockEntity.this.f_58857_, KeypadFurnaceBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return KeypadFurnaceBlockEntity.super.m_5446_();
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeSetPassword, windowId, KeypadFurnaceBlockEntity.this.f_58857_, KeypadFurnaceBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return KeypadFurnaceBlockEntity.super.m_5446_();
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, Player player) {
        this.activate(player);
        return true;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    public ContainerData getFurnaceData() {
        return this.f_58311_;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new KeypadFurnaceMenu(windowId, this.f_58857_, this.f_58858_, inv, (Container)this, this.f_58311_);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory inv) {
        return this.m_7208_(windowId, inv, inv.f_35978_);
    }

    protected Component m_6820_() {
        return new TranslatableComponent(((Block)SCContent.KEYPAD_FURNACE.get()).m_7705_());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleInserted(stack, module);
        if (!this.f_58857_.f_46443_ && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, true, stack));
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleRemoved(stack, module);
        if (!this.f_58857_.f_46443_ && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, false, stack));
        }
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_BLOCK_RL, (Object)this.m_58900_().m_60734_().getRegistryName()).build();
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }
}

