/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.blocks.BlockPocketWallBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedCrystalQuartzPillar;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedPillarBlock;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyItemStackHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.IBlockPocket;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPocketManagerBlockEntity
extends CustomizableBlockEntity
implements MenuProvider,
ITickingBlockEntity,
ILockable {
    public static final int RENDER_DISTANCE = 100;
    private static final int BLOCK_PLACEMENTS_PER_TICK = 4;
    public boolean enabled = false;
    public boolean showOutline = false;
    public int size = 5;
    public int autoBuildOffset = 0;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();
    private List<BlockPos> floor = new ArrayList<BlockPos>();
    protected NonNullList<ItemStack> storage = NonNullList.m_122780_((int)56, (Object)ItemStack.f_41583_);
    private LazyOptional<IItemHandler> storageHandler;
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private List<Pair<BlockPos, BlockState>> placeQueue = new ArrayList<Pair<BlockPos, BlockState>>();
    private boolean shouldPlaceBlocks = false;

    public BlockPocketManagerBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeBlockPocketManager, pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.shouldPlaceBlocks) {
            Player owner = PlayerUtils.getPlayerFromName(this.getOwner().getName());
            boolean isCreative = owner.m_7500_();
            boolean placed4Blocks = true;
            block0: for (int i = 0; i < 4; ++i) {
                Pair<BlockPos, BlockState> toPlace;
                BlockState stateInLevel;
                do {
                    if (this.placeQueue.isEmpty()) {
                        placed4Blocks = false;
                        break block0;
                    }
                    toPlace = this.placeQueue.remove(0);
                    if (((BlockState)toPlace.getRight()).m_60734_() instanceof IBlockPocket) continue;
                    throw new IllegalStateException(String.format("Tried to automatically place non-block pocket block \"%s\"! This mustn't happen!", ((BlockState)toPlace.getRight()).m_60734_().m_7705_()));
                } while ((stateInLevel = level.m_8055_((BlockPos)toPlace.getLeft())) == toPlace.getRight());
                if (stateInLevel.m_60767_().m_76336_()) {
                    BlockPos placeLocation = (BlockPos)toPlace.getLeft();
                    BlockState stateToPlace = (BlockState)toPlace.getRight();
                    SoundType soundType = stateToPlace.m_60827_();
                    if (!isCreative) {
                        for (int k = 0; k < this.storage.size(); ++k) {
                            ItemStack stackToCheck = (ItemStack)this.storage.get(k);
                            if (stackToCheck.m_41619_() || ((BlockItem)stackToCheck.m_41720_()).m_40614_() != stateToPlace.m_60734_()) continue;
                            stackToCheck.m_41774_(1);
                            break;
                        }
                    }
                    level.m_46597_(placeLocation, stateToPlace);
                    level.m_5594_(null, placeLocation, soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
                    BlockEntity placedBe = level.m_7702_(placeLocation);
                    if (!(placedBe instanceof OwnableBlockEntity)) continue;
                    OwnableBlockEntity ownable = (OwnableBlockEntity)placedBe;
                    ownable.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
                    continue;
                }
                PlayerUtils.sendMessageToPlayer(owner, (MutableComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), (MutableComponent)new TranslatableComponent("messages.securitycraft:blockpocket.assemblyFailed", new Object[]{this.getFormattedRelativeCoordinates((BlockPos)toPlace.getLeft(), (Direction)state.m_61143_((Property)BlockPocketManagerBlock.FACING)), new TranslatableComponent(stateInLevel.m_60734_().m_7705_())}), ChatFormatting.DARK_AQUA);
                placed4Blocks = false;
                break;
            }
            if (!placed4Blocks) {
                if (!this.placeQueue.isEmpty()) {
                    this.placeQueue.clear();
                } else {
                    this.setWalls(!this.hasModule(ModuleType.DISGUISE));
                    PlayerUtils.sendMessageToPlayer(owner, (MutableComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), (MutableComponent)new TranslatableComponent("messages.securitycraft:blockpocket.assembled"), ChatFormatting.DARK_AQUA);
                }
                this.shouldPlaceBlocks = false;
            }
        }
    }

    public TranslatableComponent enableMultiblock() {
        if (!this.enabled) {
            if (this.f_58857_.f_46443_) {
                SecurityCraft.channel.sendToServer((Object)new ToggleBlockPocketManager(this, true, this.size));
            }
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
            ArrayList<BlockPos> floor = new ArrayList<BlockPos>();
            Direction managerFacing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.m_122427_();
            Direction right = left.m_122424_();
            Direction back = left.m_122427_();
            boolean lowest = false;
            int highest = this.size - 1;
            BlockPos pos = this.m_58899_().m_7949_();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int offset = 0;
            if (!(this.f_58857_.m_8055_(pos.m_142300_(left)).m_60734_() instanceof IBlockPocket)) {
                offset = -this.autoBuildOffset + this.size / 2;
                pos = pos.m_5484_(left, offset);
            } else {
                for (int i = 1; i < this.size - 1; ++i) {
                    if (this.f_58857_.m_8055_(pos.m_5484_(left, i)).m_60734_() instanceof ReinforcedRotatedCrystalQuartzPillar) continue;
                    offset = i;
                    pos = pos.m_5484_(left, offset);
                    break;
                }
                if (offset == 0) {
                    offset = -this.autoBuildOffset + this.size / 2;
                    pos = pos.m_5484_(left, offset);
                }
            }
            BlockPos startingPos = pos.m_7949_();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.m_5484_(right, xi);
                        BlockState currentState = this.f_58857_.m_8055_(currentPos);
                        if (currentState.m_60734_() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.m_58899_())) {
                            return new TranslatableComponent("messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.m_58899_()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.m_60734_() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_()), new TranslatableComponent(((Block)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).m_7705_())});
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    if (currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                    }
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_()), new TranslatableComponent(((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_7705_())});
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    if (currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                    }
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_()), new TranslatableComponent(((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_7705_())});
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock)) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_()), new TranslatableComponent(((Block)SCContent.BLOCK_POCKET_WALL.get()).m_7705_())});
                                }
                                floor.add(currentPos);
                                sides.add(currentPos);
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.m_61143_((Property)BlockStateProperties.f_61365_) != Direction.Axis.Y) {
                                if (currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_()), new TranslatableComponent(((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_7705_())});
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock)) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_()), new TranslatableComponent(((Block)SCContent.BLOCK_POCKET_WALL.get()).m_7705_())});
                                }
                                sides.add(currentPos);
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock)) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_()), new TranslatableComponent(((Block)SCContent.BLOCK_POCKET_WALL.get()).m_7705_())});
                                }
                                sides.add(currentPos);
                            }
                        }
                        if (!this.getOwner().owns((OwnableBlockEntity)this.f_58857_.m_7702_(currentPos))) {
                            return new TranslatableComponent("messages.securitycraft:blockpocket.unowned", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                        }
                        blocks.add(currentPos);
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.m_6630_(yi).m_5484_(back, ++zi);
                }
                zi = 0;
                pos = startingPos.m_6630_(++yi);
            }
            this.blocks = blocks;
            this.walls = sides;
            this.floor = floor;
            this.enabled = true;
            this.autoBuildOffset = -offset + this.size / 2;
            for (BlockPos blockPos : blocks) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
                if (!(blockEntity instanceof BlockPocketBlockEntity)) continue;
                BlockPocketBlockEntity be = (BlockPocketBlockEntity)blockEntity;
                be.setManager(this);
            }
            for (BlockPos blockPos : floor) {
                this.f_58857_.m_46597_(blockPos, (BlockState)this.f_58857_.m_8055_(blockPos).m_61124_((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(true)));
            }
            this.setWalls(!this.hasModule(ModuleType.DISGUISE));
            return new TranslatableComponent("messages.securitycraft:blockpocket.activated");
        }
        return null;
    }

    public MutableComponent autoAssembleMultiblock() {
        if (!this.enabled) {
            BlockState currentState;
            BlockPos currentPos;
            if (this.f_58857_.f_46443_) {
                SecurityCraft.channel.sendToServer((Object)new AssembleBlockPocket(this, this.size));
            }
            Direction managerFacing = (Direction)this.m_58900_().m_61143_((Property)BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.m_122427_();
            Direction right = left.m_122424_();
            Direction back = left.m_122427_();
            boolean lowest = false;
            int half = (this.size - 1) / 2 - this.autoBuildOffset;
            int highest = this.size - 1;
            BlockPos pos = this.m_58899_().m_7949_();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int wallsNeeded = 0;
            int pillarsNeeded = 0;
            int chiseledNeeded = 0;
            pos = pos.m_5484_(right, -half);
            BlockPos startingPos = pos.m_7949_();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        BlockEntity blockEntity;
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.m_5484_(right, xi);
                        currentState = this.f_58857_.m_8055_(currentPos);
                        boolean replaceable = currentState.m_60767_().m_76336_();
                        if (yi == 0 && !currentPos.equals((Object)this.m_58899_()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.m_60734_() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() && !replaceable) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++chiseledNeeded;
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.m_61143_((Property)BlockStateProperties.f_61365_) != Direction.Axis.Y) {
                                return new TranslatableComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                            }
                            if (replaceable) {
                                ++pillarsNeeded;
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return new TranslatableComponent("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        }
                        if ((blockEntity = this.f_58857_.m_7702_(currentPos)) instanceof OwnableBlockEntity) {
                            OwnableBlockEntity be = (OwnableBlockEntity)blockEntity;
                            if (!this.getOwner().owns(be)) {
                                return new TranslatableComponent("messages.securitycraft:blockpocket.unowned", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TranslatableComponent(currentState.m_60734_().m_5456_().m_5524_())});
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.m_6630_(yi).m_5484_(back, ++zi);
                }
                zi = 0;
                pos = startingPos.m_6630_(++yi);
            }
            if (chiseledNeeded + pillarsNeeded + wallsNeeded == 0) {
                return new TranslatableComponent("messages.securitycraft:blockpocket.alreadyAssembled");
            }
            pos = this.m_58899_().m_7949_().m_5484_(right, -half);
            xi = 0;
            yi = 0;
            zi = 0;
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.m_5484_(right, xi);
                        currentState = this.f_58857_.m_8055_(currentPos);
                        if (currentState.m_60734_() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.m_58899_())) {
                            return new TranslatableComponent("messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.m_58899_()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).m_49966_()));
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_49966_().m_61124_(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace))));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_49966_().m_61124_(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace))));
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.BLOCK_POCKET_WALL.get()).m_49966_()));
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((Block)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_49966_().m_61124_(ReinforcedRotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y))));
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.BLOCK_POCKET_WALL.get()).m_49966_()));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((Block)SCContent.BLOCK_POCKET_WALL.get()).m_49966_()));
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.m_6630_(yi).m_5484_(back, ++zi);
                }
                zi = 0;
                pos = startingPos.m_6630_(++yi);
            }
            this.shouldPlaceBlocks = true;
            return null;
        }
        return null;
    }

    public void disableMultiblock() {
        if (this.enabled) {
            if (this.f_58857_.f_46443_) {
                SecurityCraft.channel.sendToServer((Object)new ToggleBlockPocketManager(this, false, this.size));
                PlayerUtils.sendMessageToPlayer(ClientHandler.getClientPlayer(), (MutableComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:blockpocket.deactivated", new Object[0]), ChatFormatting.DARK_AQUA, true);
            }
            this.enabled = false;
            for (BlockPos pos : this.blocks) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (!(blockEntity instanceof BlockPocketBlockEntity)) continue;
                BlockPocketBlockEntity be = (BlockPocketBlockEntity)blockEntity;
                be.removeManager();
            }
            for (BlockPos pos : this.floor) {
                BlockState state = this.f_58857_.m_8055_(pos);
                if (!state.m_61138_((Property)BlockPocketWallBlock.SOLID)) continue;
                this.f_58857_.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(false)));
            }
            if (this.hasModule(ModuleType.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
            this.floor.clear();
        }
    }

    private TranslatableComponent getFormattedRelativeCoordinates(BlockPos pos, Direction managerFacing) {
        int offsetBehind;
        BlockPos difference = pos.m_141950_((Vec3i)this.f_58858_);
        int offsetAbove = difference.m_123342_();
        ArrayList<TranslatableComponent> components = new ArrayList<TranslatableComponent>();
        int offsetLeft = switch (managerFacing) {
            case Direction.NORTH -> {
                offsetBehind = difference.m_123343_();
                yield difference.m_123341_();
            }
            case Direction.SOUTH -> {
                offsetBehind = -difference.m_123343_();
                yield -difference.m_123341_();
            }
            case Direction.WEST -> {
                offsetBehind = difference.m_123341_();
                yield -difference.m_123343_();
            }
            case Direction.EAST -> {
                offsetBehind = -difference.m_123341_();
                yield difference.m_123343_();
            }
            default -> throw new IllegalArgumentException("Invalid Block Pocket Manager direction: " + managerFacing.name());
        };
        if (offsetLeft > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksLeft", offsetLeft));
        } else if (offsetLeft < 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksRight", -offsetLeft));
        }
        if (offsetBehind > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksBehind", offsetBehind));
        }
        if (offsetAbove > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksAbove", offsetAbove));
        }
        return Utils.localize("messages.securitycraft:blockpocket.position." + components.size(), components.toArray());
    }

    public void toggleOutline() {
        this.showOutline = !this.showOutline;
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            BlockState state = this.f_58857_.m_8055_(pos);
            if (!(state.m_60734_() instanceof BlockPocketWallBlock)) continue;
            this.f_58857_.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockPocketWallBlock.SEE_THROUGH, (Comparable)Boolean.valueOf(seeThrough)));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isPlacingBlocks()) {
                return this.getInsertOnlyHandler().cast();
            }
            return BlockUtils.getProtectedCapability(side, this, () -> this.getStorageHandler(), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.m_46749_(this.f_58858_) && this.f_58857_.m_8055_(this.f_58858_).m_60734_() != SCContent.BLOCK_POCKET_MANAGER.get()) {
            this.disableMultiblock();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (this.enabled && module == ModuleType.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (this.enabled && module == ModuleType.DISGUISE) {
            this.setWalls(true);
        } else if (module == ModuleType.STORAGE) {
            this.getStorageHandler().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                }
            });
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        int i;
        tag.m_128379_("BlockPocketEnabled", this.enabled);
        tag.m_128379_("ShowOutline", this.showOutline);
        tag.m_128405_("Size", this.size);
        tag.m_128405_("AutoBuildOffset", this.autoBuildOffset);
        ContainerHelper.m_18973_((CompoundTag)tag, this.storage);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.m_128356_("BlocksList" + i, this.blocks.get(i).m_121878_());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.m_128356_("WallsList" + i, this.walls.get(i).m_121878_());
        }
        for (i = 0; i < this.floor.size(); ++i) {
            tag.m_128356_("FloorList" + i, this.floor.get(i).m_121878_());
        }
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        int i = 0;
        super.m_142466_(tag);
        this.enabled = tag.m_128471_("BlockPocketEnabled");
        this.showOutline = tag.m_128471_("ShowOutline");
        this.size = tag.m_128451_("Size");
        this.autoBuildOffset = tag.m_128451_("AutoBuildOffset");
        ContainerHelper.m_18980_((CompoundTag)tag, this.storage);
        while (tag.m_128441_("BlocksList" + i)) {
            this.blocks.add(BlockPos.m_122022_((long)tag.m_128454_("BlocksList" + i)));
            ++i;
        }
        i = 0;
        while (tag.m_128441_("WallsList" + i)) {
            this.walls.add(BlockPos.m_122022_((long)tag.m_128454_("WallsList" + i)));
            ++i;
        }
        i = 0;
        while (tag.m_128441_("FloorList" + i)) {
            this.floor.add(BlockPos.m_122022_((long)tag.m_128454_("FloorList" + i)));
            ++i;
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.STORAGE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new BlockPocketManagerMenu(windowId, this.f_58857_, this.f_58858_, inv);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(100.0);
    }

    public LazyOptional<IItemHandler> getStorageHandler() {
        if (this.storageHandler == null) {
            this.storageHandler = LazyOptional.of(() -> new ItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return BlockPocketManagerBlockEntity.isItemValid(stack);
                }
            });
        }
        return this.storageHandler;
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return BlockPocketManagerBlockEntity.isItemValid(stack);
                }
            });
        }
        return this.insertOnlyHandler;
    }

    public boolean isPlacingBlocks() {
        return this.shouldPlaceBlocks;
    }

    public static boolean isItemValid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return block == SCContent.BLOCK_POCKET_WALL.get() || block == SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() || block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get();
        }
        return false;
    }
}

