/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.Slider;

public abstract class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    public Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    public Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public abstract void toggle();

    public abstract void readFromNBT(CompoundTag var1);

    public abstract void writeToNBT(CompoundTag var1);

    public void copy(Option<?> option) {
        this.value = option.get();
    }

    public final String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public boolean isSlider() {
        return false;
    }

    public String toString() {
        return "" + this.value;
    }

    public static class FloatOption
    extends Option<Float> {
        public FloatOption(String optionName, Float value) {
            super(optionName, value);
        }

        public FloatOption(String optionName, Float value, Float min, Float max, Float increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
            if (((Float)this.get()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue((Float)this.getMin());
                return;
            }
            if (((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue((Float)this.getMax());
                return;
            }
            this.setValue(Float.valueOf(((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue()));
        }

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Float.valueOf(tag.m_128457_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            tag.m_128350_(this.getName(), ((Float)this.value).floatValue());
        }

        @Override
        public String toString() {
            return Float.toString(((Float)this.value).floatValue()).length() > 5 ? Float.toString(((Float)this.value).floatValue()).substring(0, 5) : Float.toString(((Float)this.value).floatValue());
        }
    }

    public static class DoubleOption
    extends Option<Double>
    implements Slider.ISlider {
        private boolean slider;
        private Supplier<BlockPos> pos;

        public DoubleOption(String optionName, Double value) {
            super(optionName, value);
            this.slider = false;
        }

        public DoubleOption(String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
            this.slider = false;
        }

        public DoubleOption(Supplier<BlockPos> pos, String optionName, Double value, Double min, Double max, Double increment, boolean s) {
            super(optionName, value, min, max, increment);
            this.slider = s;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Double)this.get() >= (Double)this.getMax()) {
                this.setValue((Double)this.getMin());
                return;
            }
            if ((Double)this.get() + (Double)this.getIncrement() >= (Double)this.getMax()) {
                this.setValue((Double)this.getMax());
                return;
            }
            this.setValue((Double)this.get() + (Double)this.getIncrement());
        }

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Double.valueOf(tag.m_128459_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            tag.m_128347_(this.getName(), ((Double)this.value).doubleValue());
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        @Override
        public boolean isSlider() {
            return this.slider;
        }

        public void onChangeSliderValue(Slider slider) {
            if (!this.isSlider() || !(slider instanceof NamedSlider)) {
                return;
            }
            NamedSlider namedSlider = (NamedSlider)slider;
            this.setValue(slider.getValue());
            slider.m_93666_((Component)Utils.localize("option" + namedSlider.getBlockName() + "." + this.getName(), this.toString()));
            SecurityCraft.channel.sendToServer((Object)new UpdateSliderValue(this.pos.get(), namedSlider.id, (Double)this.get()));
        }
    }

    public static class IntOption
    extends Option<Integer>
    implements Slider.ISlider {
        private boolean slider;
        private Supplier<BlockPos> pos;

        public IntOption(String optionName, Integer value) {
            super(optionName, value);
        }

        public IntOption(String optionName, Integer value, Integer min, Integer max, Integer increment) {
            super(optionName, value, min, max, increment);
        }

        public IntOption(Supplier<BlockPos> pos, String optionName, Integer value, Integer min, Integer max, Integer increment, boolean s) {
            super(optionName, value, min, max, increment);
            this.slider = s;
            this.pos = pos;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Integer)this.get() >= (Integer)this.getMax()) {
                this.setValue((Integer)this.getMin());
                return;
            }
            if ((Integer)this.get() + (Integer)this.getIncrement() >= (Integer)this.getMax()) {
                this.setValue((Integer)this.getMax());
                return;
            }
            this.setValue((Integer)this.get() + (Integer)this.getIncrement());
        }

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Integer.valueOf(tag.m_128451_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            tag.m_128405_(this.getName(), ((Integer)this.value).intValue());
        }

        @Override
        public boolean isSlider() {
            return this.slider;
        }

        public void onChangeSliderValue(Slider slider) {
            if (!this.isSlider() || !(slider instanceof NamedSlider)) {
                return;
            }
            NamedSlider namedSlider = (NamedSlider)slider;
            this.setValue((int)slider.getValue());
            slider.m_93666_((Component)Utils.localize("option" + namedSlider.getBlockName() + "." + this.getName(), this.toString()));
            SecurityCraft.channel.sendToServer((Object)new UpdateSliderValue(this.pos.get(), namedSlider.id, ((Integer)this.get()).intValue()));
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
        }

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Boolean.valueOf(tag.m_128471_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            tag.m_128379_(this.getName(), ((Boolean)this.value).booleanValue());
        }
    }
}

