/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LinkableBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private ListTag nbtTagStorage = null;

    public LinkableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.m_58898_() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("linkedBlocks")) {
            if (!this.m_58898_()) {
                this.nbtTagStorage = tag.m_128437_("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.m_128437_("linkedBlocks", 10));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.m_58898_() && this.linkedBlocks.size() > 0) {
            ListTag tagList = new ListTag();
            LevelUtils.addScheduledTask((LevelAccessor)this.f_58857_, () -> {
                for (int i = this.linkedBlocks.size() - 1; i >= 0; --i) {
                    LinkedBlock block = this.linkedBlocks.get(i);
                    CompoundTag toAppend = new CompoundTag();
                    if (block != null) {
                        if (!block.validate(this.f_58857_)) {
                            this.linkedBlocks.remove(i);
                            continue;
                        }
                        toAppend.m_128359_("blockName", block.blockName);
                        toAppend.m_128405_("blockX", block.getX());
                        toAppend.m_128405_("blockY", block.getY());
                        toAppend.m_128405_("blockZ", block.getZ());
                    }
                    tagList.add((Object)toAppend);
                }
                tag.m_128365_("linkedBlocks", (Tag)tagList);
            });
        }
    }

    public void m_7651_() {
        for (LinkedBlock block : this.linkedBlocks) {
            LinkableBlockEntity.unlink(block.asBlockEntity(this.f_58857_), this);
        }
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, stack, this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, stack, this);
    }

    private void readLinkedBlocks(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            String name = list.m_128728_(i).m_128461_("blockName");
            int x = list.m_128728_(i).m_128451_("blockX");
            int y = list.m_128728_(i).m_128451_("blockY");
            int z = list.m_128728_(i).m_128451_("blockZ");
            LinkedBlock block = new LinkedBlock(name, new BlockPos(x, y, z));
            if (this.m_58898_() && !block.validate(this.f_58857_)) {
                list.remove(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            LinkableBlockEntity.link(this, block.asBlockEntity(this.f_58857_));
        }
    }

    public static void link(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (LinkableBlockEntity.isLinkedWith(blockEntity1, blockEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(blockEntity1);
        LinkedBlock block2 = new LinkedBlock(blockEntity2);
        if (!blockEntity1.linkedBlocks.contains(block2)) {
            blockEntity1.linkedBlocks.add(block2);
        }
        if (!blockEntity2.linkedBlocks.contains(block1)) {
            blockEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (blockEntity1 == null || blockEntity2 == null) {
            return;
        }
        LinkedBlock block = new LinkedBlock(blockEntity2);
        if (blockEntity1.linkedBlocks.contains(block)) {
            blockEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        return blockEntity1.linkedBlocks.contains(new LinkedBlock(blockEntity2)) && blockEntity2.linkedBlocks.contains(new LinkedBlock(blockEntity1));
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, LinkableBlockEntity excludedBE) {
        ArrayList<LinkableBlockEntity> list = new ArrayList<LinkableBlockEntity>();
        list.add(excludedBE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedBEs) {
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedBEs.contains(block.asBlockEntity(this.f_58857_))) continue;
            BlockState state = this.f_58857_.m_8055_(block.getPos());
            block.asBlockEntity(this.f_58857_).onLinkedBlockAction(action, parameters, excludedBEs);
            this.f_58857_.m_7260_(block.getPos(), state, state, 3);
        }
    }

    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableBlockEntity> excludedBEs) {
    }
}

