/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.blocks.KeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCauldronBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPressurePlateBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRedstoneBlock;
import net.geforcemods.securitycraft.commands.SCCommand;
import net.geforcemods.securitycraft.compat.lycanitesmobs.LycanitesMobsCompat;
import net.geforcemods.securitycraft.compat.quark.QuarkCompat;
import net.geforcemods.securitycraft.compat.top.TOPDataProvider;
import net.geforcemods.securitycraft.itemgroups.SCDecorationTab;
import net.geforcemods.securitycraft.itemgroups.SCExplosivesTab;
import net.geforcemods.securitycraft.itemgroups.SCTechnicalTab;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.CommonDoorActivator;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.misc.conditions.BlockEntityNBTCondition;
import net.geforcemods.securitycraft.util.HasManualPage;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="securitycraft")
@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SecurityCraft {
    public static final String MODID = "securitycraft";
    public static final String PROTOCOL_VERSION = "4";
    public static SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("securitycraft", "securitycraft"), () -> "4", "4"::equals, "4"::equals);
    public static CreativeModeTab technicalTab = new SCTechnicalTab();
    public static CreativeModeTab mineTab = new SCExplosivesTab();
    public static CreativeModeTab decorationTab = new SCDecorationTab();
    public static final LootItemConditionType BLOCK_ENTITY_NBT_LOOT_CONDITION = LootItemConditions.m_81831_((String)"securitycraft:tile_entity_nbt", (Serializer)new BlockEntityNBTCondition.ConditionSerializer());

    public SecurityCraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigHandler.SERVER_SPEC);
        SCContent.BLOCKS.register(modEventBus);
        SCContent.FLUIDS.register(modEventBus);
        SCContent.ITEMS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        RegistrationHandler.registerPackets();
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"registerExtractionBlock", ReinforcedHopperBlock.ExtractionBlock::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadChestBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadFurnaceBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", CommonDoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", InventoryScannerBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedPressurePlateBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedRedstoneBlock.DoorActivator::new);
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPDataProvider::new);
        }
        if (ModList.get().isLoaded("lycanitesmobs")) {
            InterModComms.sendTo((String)MODID, (String)"registerSentryAttackTargetCheck", LycanitesMobsCompat::new);
        }
        if (ModList.get().isLoaded("quark")) {
            QuarkCompat.registerChestConversions();
        }
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        for (Field field : SCContent.class.getFields()) {
            try {
                if (field.isAnnotationPresent(Reinforced.class)) {
                    Block block = (Block)((RegistryObject)field.get(null)).get();
                    IReinforcedBlock rb = (IReinforcedBlock)block;
                    IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.put(rb.getVanillaBlock(), block);
                    IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.put(block, rb.getVanillaBlock());
                }
                if (!field.isAnnotationPresent(HasManualPage.class)) continue;
                IForgeRegistryEntry o = ((RegistryObject)field.get(null)).get();
                HasManualPage hmp = field.getAnnotation(HasManualPage.class);
                Item item = ((ItemLike)o).m_5456_();
                Object key = "help.";
                key = hmp.specialInfoKey().isEmpty() ? (String)key + item.m_5524_().substring(5) + ".info" : (String)key + hmp.specialInfoKey();
                SCManualItem.PAGES.add(new SCManualPage(item, new TranslatableComponent(((String)key).replace("..", ".")), hmp.designedBy(), hmp.hasRecipeDescription()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, (level, ticketHelper) -> ticketHelper.getEntityTickets().forEach((uuid, chunk) -> {
            if (level.m_8791_(uuid) == null) {
                ticketHelper.removeAllTickets(uuid);
            }
        }));
        ReinforcedCauldronBlock.IReinforcedCauldronInteraction.bootStrap();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        SCCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static String getVersion() {
        return "v" + ((ModContainer)ModList.get().getModContainerById(MODID).get()).getModInfo().getVersion().toString();
    }
}

