/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("textures/mob_effect/night_vision.png");
    private static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.f_42451_);
    private static final Component REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SecurityCamera camera = (SecurityCamera)Minecraft.m_91087_().f_91075_;
            if (camera.screenshotSoundCooldown == 0) {
                camera.screenshotSoundCooldown = 7;
                Minecraft.m_91087_().f_91073_.m_104677_(player.m_142538_(), SCSounds.CAMERASNAP.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.ClickInputEvent event) {
        if (event.isAttack() && ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenOpenEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen || screen instanceof JoinMultiplayerScreen) {
            OverlayRegistry.enableOverlay((IIngameOverlay)ClientHandler.cameraOverlay, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ClientHandler.hotbarBindOverlay, (boolean)true);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.JUMP_BAR_ELEMENT, (boolean)true);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (boolean)true);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.POTION_ICONS_ELEMENT, (boolean)true);
        }
    }

    public static void cameraOverlay(ForgeIngameGui gui, PoseStack pose, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos pos = mc.f_91075_.m_142538_();
        Window window = mc.m_91268_();
        if (mc.f_91066_.f_92063_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            return;
        }
        SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
        Font font = Minecraft.m_91087_().f_91062_;
        Options settings = Minecraft.m_91087_().f_91066_;
        boolean hasRedstoneModule = be.hasModule(ModuleType.REDSTONE);
        BlockState state = level.m_8055_(pos);
        TranslatableComponent lookAround = Utils.localize("gui.securitycraft:camera.lookAround", settings.f_92085_.m_90863_(), settings.f_92086_.m_90863_(), settings.f_92087_.m_90863_(), settings.f_92088_.m_90863_());
        TranslatableComponent exit = Utils.localize("gui.securitycraft:camera.exit", settings.f_92090_.m_90863_());
        TranslatableComponent zoom = Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.m_90863_(), KeyBindings.cameraZoomOut.m_90863_());
        TranslatableComponent nightVision = Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.m_90863_());
        TranslatableComponent redstone = Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.m_90863_());
        String time = ClientUtils.getFormattedMinecraftTime();
        int timeY = 25;
        if (be.m_8077_()) {
            Component cameraName = be.m_7770_();
            font.m_92763_(pose, cameraName, (float)(window.m_85445_() - font.m_92852_((FormattedText)cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        font.m_92750_(pose, time, (float)(window.m_85445_() - font.m_92895_(time) - 4), (float)timeY, 0xFFFFFF);
        font.m_92763_(pose, (Component)lookAround, (float)(window.m_85445_() - font.m_92852_((FormattedText)lookAround) - 8), (float)(window.m_85446_() - 80), 0xFFFFFF);
        font.m_92763_(pose, (Component)exit, (float)(window.m_85445_() - font.m_92852_((FormattedText)exit) - 8), (float)(window.m_85446_() - 70), 0xFFFFFF);
        font.m_92763_(pose, (Component)zoom, (float)(window.m_85445_() - font.m_92852_((FormattedText)zoom) - 8), (float)(window.m_85446_() - 60), 0xFFFFFF);
        font.m_92763_(pose, (Component)nightVision, (float)(window.m_85445_() - font.m_92852_((FormattedText)nightVision) - 8), (float)(window.m_85446_() - 50), 0xFFFFFF);
        font.m_92763_(pose, (Component)redstone, (float)(window.m_85445_() - font.m_92852_((FormattedText)redstone) - 8), (float)(window.m_85446_() - 40), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        font.m_92763_(pose, REDSTONE_NOTE, (float)(window.m_85445_() - font.m_92852_((FormattedText)REDSTONE_NOTE) - 8), (float)(window.m_85446_() - 30), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        RenderSystem.m_157179_((int)0, (ResourceLocation)CAMERA_DASHBOARD);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_93228_(pose, 5, 0, 0, 0, 90, 20);
        gui.m_93228_(pose, window.m_85445_() - 70, 5, 190, 0, 65, 30);
        if (!mc.f_91074_.m_21023_(MobEffects.f_19611_)) {
            gui.m_93228_(pose, 28, 4, 90, 12, 16, 11);
        } else {
            RenderSystem.m_157179_((int)0, (ResourceLocation)NIGHT_VISION);
            GuiComponent.m_93133_((PoseStack)pose, (int)27, (int)-1, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            RenderSystem.m_157179_((int)0, (ResourceLocation)CAMERA_DASHBOARD);
        }
        if (state.m_60746_((BlockGetter)level, pos, (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0) {
            if (!hasRedstoneModule) {
                gui.m_93228_(pose, 12, 2, 104, 0, 12, 12);
            } else {
                gui.m_93228_(pose, 12, 3, 90, 0, 12, 11);
            }
        } else {
            Minecraft.m_91087_().m_91291_().m_115203_(REDSTONE, 10, 0);
        }
    }

    public static void hotbarBindOverlay(ForgeIngameGui gui, PoseStack pose, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Level level = player.m_20193_();
        double reachDistance = mc.f_91072_.m_105286_();
        for (InteractionHand hand : InteractionHand.values()) {
            int uCoord = 0;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == SCContent.CAMERA_MONITOR.get()) {
                double eyeHeight = player.m_20192_();
                Vec3 lookVec = new Vec3(player.m_20185_() + player.m_20154_().f_82479_ * reachDistance, eyeHeight + player.m_20186_() + player.m_20154_().f_82480_ * reachDistance, player.m_20189_() + player.m_20154_().f_82481_ * reachDistance);
                hitResult = level.m_45547_(new ClipContext(new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                if (hitResult instanceof BlockHitResult && level.m_7702_((bhr = hitResult).m_82425_()) instanceof SecurityCameraBlockEntity) {
                    CompoundTag cameras = stack.m_41784_();
                    uCoord = 110;
                    for (int i = 1; i < 31; ++i) {
                        if (!cameras.m_128441_("Camera" + i) || Integer.parseInt((coords = cameras.m_128461_("Camera" + i).split(" "))[0]) != bhr.m_82425_().m_123341_() || Integer.parseInt(coords[1]) != bhr.m_82425_().m_123342_() || Integer.parseInt(coords[2]) != bhr.m_82425_().m_123343_()) continue;
                        uCoord = 88;
                        break;
                    }
                }
            } else if (stack.m_41720_() == SCContent.REMOTE_ACCESS_MINE.get()) {
                double eyeHeight = player.m_20192_();
                Vec3 lookVec = new Vec3(player.m_20185_() + player.m_20154_().f_82479_ * reachDistance, eyeHeight + player.m_20186_() + player.m_20154_().f_82480_ * reachDistance, player.m_20189_() + player.m_20154_().f_82481_ * reachDistance);
                hitResult = level.m_45547_(new ClipContext(new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                if (hitResult instanceof BlockHitResult && level.m_8055_((bhr = hitResult).m_82425_()).m_60734_() instanceof IExplosive) {
                    uCoord = 110;
                    CompoundTag mines = stack.m_41784_();
                    for (int i = 1; i <= 6; ++i) {
                        if (stack.m_41783_().m_128465_("mine" + i).length <= 0 || (coords = (Object[])mines.m_128465_("mine" + i))[0] != bhr.m_82425_().m_123341_() || coords[1] != bhr.m_82425_().m_123342_() || coords[2] != bhr.m_82425_().m_123343_()) continue;
                        uCoord = 88;
                        break;
                    }
                }
            } else if (stack.m_41720_() == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                Entity entity = Minecraft.m_91087_().f_91076_;
                if (entity instanceof Sentry) {
                    Sentry sentry = (Sentry)entity;
                    CompoundTag sentries = stack.m_41784_();
                    uCoord = 110;
                    for (int i = 1; i <= 12; ++i) {
                        int[] coords;
                        if (stack.m_41783_().m_128465_("sentry" + i).length <= 0 || (coords = sentries.m_128465_("sentry" + i))[0] != sentry.m_142538_().m_123341_() || coords[1] != sentry.m_142538_().m_123342_() || coords[2] != sentry.m_142538_().m_123343_()) continue;
                        uCoord = 88;
                        break;
                    }
                }
            } else if (stack.m_41720_() == SCContent.SONIC_SECURITY_SYSTEM_ITEM.get()) {
                BlockEntity i;
                double eyeHeight = player.m_20192_();
                Vec3 lookVec = new Vec3(player.m_20185_() + player.m_20154_().f_82479_ * reachDistance, eyeHeight + player.m_20186_() + player.m_20154_().f_82480_ * reachDistance, player.m_20189_() + player.m_20154_().f_82481_ * reachDistance);
                hitResult = level.m_45547_(new ClipContext(new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                if (hitResult instanceof BlockHitResult && (i = level.m_7702_((bhr = hitResult).m_82425_())) instanceof ILockable) {
                    DisguisableBlock disguisable;
                    Block block;
                    IOwnable ownable;
                    ILockable lockable = (ILockable)i;
                    BlockPos pos = bhr.m_82425_();
                    if (!(lockable instanceof IOwnable && (ownable = (IOwnable)((Object)lockable)).getOwner().isOwner((Player)player) || !((block = lockable.getThisBlockEntity().m_58900_().m_60734_()) instanceof DisguisableBlock) || (disguisable = (DisguisableBlock)block).getDisguisedBlockState((BlockGetter)level, pos) == null)) {
                        return;
                    }
                    uCoord = SonicSecuritySystemItem.isAdded(stack.m_41784_(), pos) ? 88 : 110;
                }
            }
            if (uCoord == 0) continue;
            RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
            GuiComponent.m_93133_((PoseStack)pose, (int)(Minecraft.m_91087_().m_91268_().m_85445_() / 2 - 90 + (hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ * 20 : (mc.f_91066_.f_92127_ == HumanoidArm.LEFT ? 189 : -29))), (int)(Minecraft.m_91087_().m_91268_().m_85446_() - 22), (float)uCoord, (float)219.0f, (int)21, (int)22, (int)256, (int)256);
        }
    }
}

