/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.base.Predicate;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldUtil {
    private static final Predicate<Entity> CAN_COLLIDE = x -> x != null && x.m_6084_() && x.m_6087_();
    private static final Map<Level, Entity> entityCache = new MapMaker().weakKeys().weakValues().makeMap();

    private static synchronized Entity getEntity(Level world) {
        Object entity = entityCache.get(world);
        if (entity != null) {
            return entity;
        }
        entity = new ItemEntity(EntityType.f_20461_, world){

            @Nonnull
            public EntityDimensions m_6972_(@Nonnull Pose pose) {
                return EntityDimensions.m_20398_((float)0.0f, (float)0.0f);
            }
        };
        entity.f_19794_ = true;
        entity.m_6210_();
        entityCache.put(world, (Entity)entity);
        return entity;
    }

    public static boolean isLiquidBlock(Level world, BlockPos pos) {
        if (!world.m_46739_(pos)) {
            return false;
        }
        return world.m_8055_(pos).m_60767_().m_76332_();
    }

    public static boolean isVecInside(VoxelShape shape, Vec3 vec) {
        if (shape.m_83281_()) {
            return false;
        }
        AABB bb = shape.m_83215_();
        return vec.f_82479_ >= bb.f_82288_ && vec.f_82479_ <= bb.f_82291_ && vec.f_82480_ >= bb.f_82289_ && vec.f_82480_ <= bb.f_82292_ && vec.f_82481_ >= bb.f_82290_ && vec.f_82481_ <= bb.f_82293_;
    }

    public static Pair<Entity, Vec3> rayTraceEntities(Level world, Vec3 vecStart, Vec3 vecDir, double distance) {
        Vec3 vecEnd = vecStart.m_82520_(vecDir.f_82479_ * distance, vecDir.f_82480_ * distance, vecDir.f_82481_ * distance);
        Entity collisionEntity = WorldUtil.getEntity(world);
        collisionEntity.m_6034_(vecStart.f_82479_, vecStart.f_82480_, vecStart.f_82481_);
        ClipContext context = new ClipContext(vecStart, vecEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, collisionEntity);
        BlockHitResult result = world.m_45547_(context);
        if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
            distance = vecStart.m_82554_(result.m_82450_());
            vecEnd = vecStart.m_82520_(vecDir.f_82479_ * distance, vecDir.f_82480_ * distance, vecDir.f_82481_ * distance);
        }
        float xStretch = Math.abs(vecDir.f_82479_) > 0.25 ? 0.0f : 1.0f;
        float yStretch = Math.abs(vecDir.f_82480_) > 0.25 ? 0.0f : 1.0f;
        float zStretch = Math.abs(vecDir.f_82481_) > 0.25 ? 0.0f : 1.0f;
        AABB bigBox = new AABB(Math.min(vecStart.f_82479_, vecEnd.f_82479_) - (double)(0.375f * xStretch), Math.min(vecStart.f_82480_, vecEnd.f_82480_) - (double)(0.375f * yStretch), Math.min(vecStart.f_82481_, vecEnd.f_82481_) - (double)(0.375f * zStretch), Math.max(vecStart.f_82479_, vecEnd.f_82479_) + (double)(0.375f * xStretch), Math.max(vecStart.f_82480_, vecEnd.f_82480_) + (double)(0.375f * yStretch), Math.max(vecStart.f_82481_, vecEnd.f_82481_) + (double)(0.375f * zStretch));
        Entity closest = null;
        double closestDist = 99.0;
        List list = world.m_6443_(Entity.class, bigBox, CAN_COLLIDE);
        for (Entity entity : list) {
            AABB littleBox = entity.m_142469_();
            if (littleBox.m_82390_(vecStart)) {
                closest = entity;
                closestDist = 0.0;
                continue;
            }
            Vec3 littleBoxResult = littleBox.m_82371_(vecStart, vecEnd).orElse(null);
            if (littleBoxResult != null) {
                double dist = vecStart.m_82554_(littleBoxResult);
                if (closest != null && !(dist <= closestDist)) continue;
                closest = entity;
                closestDist = dist;
                continue;
            }
            if (!littleBox.m_82381_(bigBox) || closest != null) continue;
            closest = entity;
            closestDist = distance;
        }
        if (closest != null && closestDist <= distance) {
            Vec3 closestPos = vecStart.m_82520_(vecDir.f_82479_ * closestDist, vecDir.f_82480_ * closestDist, vecDir.f_82481_ * closestDist);
            return Pair.of((Object)closest, (Object)closestPos);
        }
        return null;
    }

    public static Vec3 getRayStart(LivingEntity entity) {
        return entity.m_20299_(1.0f);
    }

    public static Vec3 getRayEnd(Player player) {
        double reach = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        Vec3 look = player.m_20154_();
        return WorldUtil.getRayStart((LivingEntity)player).m_82520_(look.f_82479_ * reach, look.f_82480_ * reach, look.f_82481_ * reach);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, Level world, BlockPos pos) {
        WorldUtil.dropItemStack(stack, world, pos, null);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, Level world, BlockPos pos, Direction direction) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.m_122429_();
            yDir = direction.m_122430_();
            zDir = direction.m_122431_();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.m_123341_() + 0.5 + xDir * 0.4;
        double yPos = (double)pos.m_123342_() + 0.5 + yDir * 0.4;
        double zPos = (double)pos.m_123343_() + 0.5 + zDir * 0.4;
        WorldUtil.dropItemStack(stack, world, new Vec3(xPos, yPos, zPos), xDir, yDir, zDir);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, Level world, Vec3 pos) {
        WorldUtil.dropItemStack(stack, world, pos, 0.0, 0.0, 0.0);
    }

    public static void dropItemStack(@Nonnull ItemStack stack, Level world, Vec3 pos, double xDir, double yDir, double zDir) {
        ItemEntity item = new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack.m_41777_());
        item.m_20334_(xDir * 0.7 + (double)world.m_5822_().nextFloat() * 0.2 - 0.1, yDir * 0.7 + (double)world.m_5822_().nextFloat() * 0.2 - 0.1, zDir * 0.7 + (double)world.m_5822_().nextFloat() * 0.2 - 0.1);
        item.m_32060_();
        world.m_7967_((Entity)item);
    }
}

