/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.IUpgradeBase;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class TurtleToolSerialiser
extends TurtleUpgradeSerialiser.Base<TurtleTool> {
    public static final TurtleToolSerialiser INSTANCE = new TurtleToolSerialiser();

    private TurtleToolSerialiser() {
    }

    @Override
    @Nonnull
    public TurtleTool fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject object) {
        String adjective = GsonHelper.m_13851_((JsonObject)object, (String)"adjective", (String)IUpgradeBase.getDefaultAdjective(id));
        Item toolItem = GsonHelper.m_13909_((JsonObject)object, (String)"item");
        Item craftingItem = GsonHelper.m_144746_((JsonObject)object, (String)"craftingItem", (Item)toolItem);
        float damageMultiplier = GsonHelper.m_13820_((JsonObject)object, (String)"damageMultiplier", (float)3.0f);
        ResourceLocation breakableName = null;
        Tag breakable = null;
        if (object.has("breakable")) {
            breakableName = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"breakable"));
            breakable = SerializationTags.m_13199_().m_144458_(Registry.f_122901_, breakableName, tagId -> new JsonSyntaxException("Unknown item tag '" + tagId + "'"));
        }
        return new TurtleTool(id, adjective, craftingItem, new ItemStack((ItemLike)toolItem), damageMultiplier, breakableName, (Tag<Block>)breakable);
    }

    @Override
    @Nonnull
    public TurtleTool fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
        String adjective = buffer.m_130277_();
        Item craftingItem = (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
        ItemStack toolItem = buffer.m_130267_();
        float damageMultiplier = buffer.readFloat();
        ResourceLocation breakableName = null;
        Tag breakable = null;
        if (buffer.readBoolean()) {
            breakableName = buffer.m_130281_();
            breakable = SerializationTags.m_13199_().m_144452_(Registry.f_122901_).m_7689_(breakableName);
        }
        return new TurtleTool(id, adjective, craftingItem, toolItem, damageMultiplier, breakableName, (Tag<Block>)breakable);
    }

    @Override
    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull TurtleTool upgrade) {
        buffer.m_130070_(upgrade.getUnlocalisedAdjective());
        buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (IForgeRegistryEntry)upgrade.getCraftingItem().m_41720_());
        buffer.m_130055_(upgrade.item);
        buffer.writeFloat(upgrade.damageMulitiplier);
        buffer.writeBoolean(upgrade.breakableName != null);
        if (upgrade.breakableName != null) {
            buffer.m_130085_(upgrade.breakableName);
        }
    }
}

