/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.data;

import com.google.gson.JsonParseException;
import dan200.computercraft.shared.peripheral.generic.data.DataHelpers;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ItemData {
    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasicSafe(@Nonnull T data, @Nonnull ItemStack stack) {
        data.put((String)"name", (String)DataHelpers.getId(stack.m_41720_()));
        data.put((String)"count", stack.m_41613_());
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasic(@Nonnull T data, @Nonnull ItemStack stack) {
        ItemData.fillBasicSafe(data, stack);
        String hash = NBTUtil.getNBTHash(stack.m_41783_());
        if (hash != null) {
            data.put((String)"nbt", (String)hash);
        }
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fill(@Nonnull T data, @Nonnull ItemStack stack) {
        int hideFlags;
        List<Map<String, Object>> enchants;
        CompoundTag displayTag;
        if (stack.m_41619_()) {
            return data;
        }
        ItemData.fillBasic(data, stack);
        data.put((String)"displayName", (String)stack.m_41786_().getString());
        data.put((String)"maxCount", stack.m_41741_());
        if (stack.m_41763_()) {
            data.put((String)"damage", stack.m_41773_());
            data.put((String)"maxDamage", stack.m_41776_());
        }
        if (stack.m_41720_().m_142522_(stack)) {
            data.put((String)"durability", (double)stack.m_41720_().m_142158_(stack) / 13.0);
        }
        data.put((String)"tags", DataHelpers.getTags(stack.m_41720_().getTags()));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("display", 10) && (displayTag = tag.m_128469_("display")).m_128425_("Lore", 9)) {
            ListTag loreTag = displayTag.m_128437_("Lore", 8);
            data.put((String)"lore", loreTag.stream().map(ItemData::parseTextComponent).filter(Objects::nonNull).map(Component::getString).collect(Collectors.toList()));
        }
        if (!(enchants = ItemData.getAllEnchants(stack, hideFlags = tag != null ? tag.m_128451_("HideFlags") : 0)).isEmpty()) {
            data.put((String)"enchantments", enchants);
        }
        if (tag != null && tag.m_128471_("Unbreakable") && (hideFlags & 4) == 0) {
            data.put((String)"unbreakable", true);
        }
        return data;
    }

    @Nullable
    private static Component parseTextComponent(@Nonnull Tag x) {
        try {
            return Component.Serializer.m_130701_((String)x.m_7916_());
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nonnull
    private static List<Map<String, Object>> getAllEnchants(@Nonnull ItemStack stack, int hideFlags) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        if (stack.m_41720_() instanceof EnchantedBookItem && (hideFlags & 0x20) == 0) {
            ItemData.addEnchantments(EnchantedBookItem.m_41163_((ItemStack)stack), enchants);
        }
        if (stack.m_41793_() && (hideFlags & 1) == 0) {
            ItemData.addEnchantments(stack.m_41785_(), enchants);
        }
        return enchants;
    }

    private static void addEnchantments(@Nonnull ListTag rawEnchants, @Nonnull ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Map.Entry entry : EnchantmentHelper.m_44882_((ListTag)rawEnchants).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", DataHelpers.getId(enchantment));
            enchant.put("level", level);
            enchant.put("displayName", enchantment.m_44700_(level.intValue()).getString());
            enchants.add(enchant);
        }
    }
}

