/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.shared.media.items.ItemPrintout;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public final class PrintoutRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<?> SERIALIZER = new SimpleRecipeSerializer(PrintoutRecipe::new);

    private PrintoutRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean m_8004_(int x, int y) {
        return x >= 3 && y >= 3;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemPrintout.createMultipleFromTitleAndText(null, null, null);
    }

    public boolean matches(@Nonnull CraftingContainer inventory, @Nonnull Level world) {
        return !this.assemble(inventory).m_41619_();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inventory) {
        int numPages = 0;
        int numPrintouts = 0;
        ItemStack[] printouts = null;
        boolean stringFound = false;
        boolean leatherFound = false;
        boolean printoutFound = false;
        for (int y = 0; y < inventory.m_39346_(); ++y) {
            for (int x = 0; x < inventory.m_39347_(); ++x) {
                ItemPrintout printout;
                ItemStack stack = inventory.m_8020_(x + y * inventory.m_39347_());
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item instanceof ItemPrintout && (printout = (ItemPrintout)item).getType() != ItemPrintout.Type.BOOK) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    numPages += ItemPrintout.getPageCount(stack);
                    ++numPrintouts;
                    printoutFound = true;
                    continue;
                }
                if (stack.m_41720_() == Items.f_42516_) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    ++numPages;
                    ++numPrintouts;
                    continue;
                }
                if (Tags.Items.STRING.m_8110_((Object)stack.m_41720_()) && !stringFound) {
                    stringFound = true;
                    continue;
                }
                if (Tags.Items.LEATHER.m_8110_((Object)stack.m_41720_()) && !leatherFound) {
                    leatherFound = true;
                    continue;
                }
                return ItemStack.f_41583_;
            }
        }
        if (numPages <= 16 && stringFound && printoutFound && numPrintouts >= (leatherFound ? 1 : 2)) {
            String[] text = new String[numPages * 21];
            String[] colours = new String[numPages * 21];
            int line = 0;
            for (int printout = 0; printout < numPrintouts; ++printout) {
                void stack = printouts[printout];
                if (stack.m_41720_() instanceof ItemPrintout) {
                    String[] pageText = ItemPrintout.getText(printouts[printout]);
                    String[] pageColours = ItemPrintout.getColours(printouts[printout]);
                    for (int pageLine = 0; pageLine < pageText.length; ++pageLine) {
                        text[line] = pageText[pageLine];
                        colours[line] = pageColours[pageLine];
                        ++line;
                    }
                    continue;
                }
                for (int pageLine = 0; pageLine < 21; ++pageLine) {
                    text[line] = "";
                    colours[line] = "";
                    ++line;
                }
            }
            String title = null;
            if (printouts[0].m_41720_() instanceof ItemPrintout) {
                title = ItemPrintout.getTitle(printouts[0]);
            }
            if (leatherFound) {
                return ItemPrintout.createBookFromTitleAndText(title, text, colours);
            }
            return ItemPrintout.createMultipleFromTitleAndText(title, text, colours);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

