/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.util.CapabilityUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileComputer
extends TileComputerBase {
    private ComputerProxy proxy;
    private LazyOptional<IPeripheral> peripheral;

    public TileComputer(BlockEntityType<? extends TileComputer> type, BlockPos pos, BlockState state, ComputerFamily family) {
        super(type, pos, state, family);
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ComputerFamily family = this.getFamily();
        ServerComputer computer = new ServerComputer(this.m_58904_(), id, this.label, instanceID, family, ComputerCraft.computerTermWidth, ComputerCraft.computerTermHeight);
        computer.setPosition(this.m_58899_());
        return computer;
    }

    protected boolean isUsableByPlayer(Player player) {
        return this.isUsable(player, false);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockComputer.FACING);
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
        BlockState existing = this.m_58900_();
        if (existing.m_61143_(BlockComputer.STATE) != newState) {
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)existing.m_61124_(BlockComputer.STATE, (Comparable)((Object)newState)), 3);
        }
    }

    @Override
    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        if (localSide == ComputerSide.RIGHT) {
            return ComputerSide.LEFT;
        }
        if (localSide == ComputerSide.LEFT) {
            return ComputerSide.RIGHT;
        }
        return localSide;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
        return new ComputerMenuWithoutInventory((MenuType<? extends ContainerComputerBase>)((MenuType)Registry.ModContainers.COMPUTER.get()), id, inventory, this::isUsableByPlayer, this.createServerComputer(), this.getFamily());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheral == null) {
                this.peripheral = LazyOptional.of(() -> {
                    if (this.proxy == null) {
                        this.proxy = new ComputerProxy(() -> this);
                    }
                    return new ComputerPeripheral("computer", this.proxy);
                });
            }
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.peripheral = CapabilityUtil.invalidate(this.peripheral);
    }
}

