/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.client.render.MonitorTextureBufferShader;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.lwjgl.opengl.GL11;

public class TileEntityMonitorRenderer
implements BlockEntityRenderer<TileMonitor> {
    private static final float MARGIN = 0.034375f;
    private static ByteBuffer tboContents;
    private static final Matrix4f IDENTITY;

    public TileEntityMonitorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull TileMonitor monitor, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource renderer, int lightmapCoord, int overlayLight) {
        ClientMonitor originTerminal = monitor.getClientMonitor();
        if (originTerminal == null) {
            return;
        }
        TileMonitor origin = originTerminal.getOrigin();
        BlockPos monitorPos = monitor.m_58899_();
        long renderFrame = FrameInfo.getRenderFrame();
        if (originTerminal.lastRenderFrame == renderFrame && !monitorPos.equals((Object)originTerminal.lastRenderPos)) {
            return;
        }
        originTerminal.lastRenderFrame = renderFrame;
        originTerminal.lastRenderPos = monitorPos;
        BlockPos originPos = origin.m_58899_();
        Direction dir = origin.getDirection();
        Direction front = origin.getFront();
        float yaw = dir.m_122435_();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.m_85836_();
        transform.m_85837_((double)(originPos.m_123341_() - monitorPos.m_123341_()) + 0.5, (double)(originPos.m_123342_() - monitorPos.m_123342_()) + 0.5, (double)(originPos.m_123343_() - monitorPos.m_123343_()) + 0.5);
        transform.m_85845_(Vector3f.f_122224_.m_122240_(yaw));
        transform.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        transform.m_85837_(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.m_85836_();
            transform.m_85841_((float)xScale, (float)(-yScale), 1.0f);
            Matrix4f matrix = transform.m_85850_().m_85861_();
            TileEntityMonitorRenderer.renderTerminal(renderer, matrix, originTerminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            FixedWidthFontRenderer.drawCursor(matrix, renderer.m_6299_(RenderTypes.TERMINAL_WITHOUT_DEPTH), 0.0f, 0.0f, terminal, !originTerminal.isColour());
            transform.m_85849_();
            FixedWidthFontRenderer.drawBlocker(transform.m_85850_().m_85861_(), renderer, -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
            renderer.m_6299_(RenderType.m_110451_());
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(transform.m_85850_().m_85861_(), renderer, -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        transform.m_85849_();
    }

    private static void renderTerminal(@Nonnull MultiBufferSource renderer, Matrix4f matrix, ClientMonitor monitor, float xMargin, float yMargin) {
        Terminal terminal = monitor.getTerminal();
        MonitorRenderer renderType = MonitorRenderer.current();
        boolean redraw = monitor.pollTerminalChanged();
        if (monitor.createBuffer(renderType)) {
            redraw = true;
        }
        switch (renderType) {
            case TBO: {
                int width = terminal.getWidth();
                int height = terminal.getHeight();
                int pixelWidth = width * 6;
                int pixelHeight = height * 9;
                if (redraw) {
                    int size = width * height * 3;
                    if (tboContents == null || tboContents.capacity() < size) {
                        tboContents = MemoryTracker.m_182527_((int)size);
                    }
                    ByteBuffer monitorBuffer = tboContents;
                    monitorBuffer.clear();
                    for (int y = 0; y < height; ++y) {
                        TextBuffer text = terminal.getLine(y);
                        TextBuffer textColour = terminal.getTextColourLine(y);
                        TextBuffer background = terminal.getBackgroundColourLine(y);
                        for (int x = 0; x < width; ++x) {
                            monitorBuffer.put((byte)(text.charAt(x) & 0xFF));
                            monitorBuffer.put((byte)FixedWidthFontRenderer.getColour(textColour.charAt(x), Colour.WHITE));
                            monitorBuffer.put((byte)FixedWidthFontRenderer.getColour(background.charAt(x), Colour.BLACK));
                        }
                    }
                    monitorBuffer.flip();
                    GlStateManager.m_84480_((int)35882, (int)monitor.tboBuffer);
                    GlStateManager.m_84256_((int)35882, (ByteBuffer)monitorBuffer, (int)35044);
                    GlStateManager.m_84480_((int)35882, (int)0);
                }
                int active = GlStateManager.m_157058_();
                RenderSystem.m_69388_((int)33987);
                GL11.glBindTexture((int)35882, (int)monitor.tboTexture);
                RenderSystem.m_69388_((int)active);
                MonitorTextureBufferShader shader = RenderTypes.getMonitorTextureBufferShader();
                shader.setupUniform(width, height, terminal.getPalette(), !monitor.isColour());
                VertexConsumer buffer = renderer.m_6299_(RenderTypes.MONITOR_TBO);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, -xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, -xMargin, (float)pixelHeight + yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, (float)pixelWidth + xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, (float)pixelWidth + xMargin, (float)pixelHeight + yMargin);
                renderer.m_6299_(RenderTypes.TERMINAL_WITHOUT_DEPTH);
                break;
            }
            case VBO: {
                VertexBuffer vbo = monitor.buffer;
                if (redraw) {
                    Tesselator tessellator = Tesselator.m_85913_();
                    BufferBuilder builder = tessellator.m_85915_();
                    builder.m_166779_(RenderTypes.TERMINAL_WITHOUT_DEPTH.m_173186_(), RenderTypes.TERMINAL_WITHOUT_DEPTH.m_110508_());
                    FixedWidthFontRenderer.drawTerminalWithoutCursor(IDENTITY, (VertexConsumer)builder, 0.0f, 0.0f, terminal, !monitor.isColour(), yMargin, yMargin, xMargin, xMargin);
                    builder.m_85721_();
                    vbo.m_85925_(builder);
                }
                renderer.m_6299_(RenderTypes.TERMINAL_WITHOUT_DEPTH);
                RenderTypes.TERMINAL_WITHOUT_DEPTH.m_110185_();
                vbo.m_166867_(matrix, RenderSystem.m_157192_(), RenderTypes.getTerminalShader());
                break;
            }
        }
    }

    private static void tboVertex(VertexConsumer builder, Matrix4f matrix, float x, float y) {
        builder.m_85982_(matrix, x, y, 0.0f).m_7421_(x, y).m_5752_();
    }

    public int m_142163_() {
        return ComputerCraft.monitorDistance;
    }

    static {
        IDENTITY = Transformation.m_121093_().m_121104_();
    }
}

