/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.entity.SeatEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParkBenchBlock
extends FurnitureHorizontalWaterloggedBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ParkBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)Type.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] SEAT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)8.0, (double)3.0, (double)16.0, (double)9.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BACKREST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)9.0, (double)1.0, (double)16.0, (double)20.0, (double)5.0), Direction.SOUTH));
        VoxelShape[] BACK_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)4.0, (double)8.0, (double)6.0), Direction.SOUTH));
        VoxelShape[] FRONT_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] FRONT_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] BACK_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)12.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)6.0), Direction.SOUTH));
        VoxelShape[] LEFT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)6.0, (double)6.0, (double)4.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] RIGHT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)15.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] FRONT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] BACK_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)6.0, (double)3.0, (double)15.0, (double)8.0, (double)6.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            Type type = (Type)((Object)state.m_61143_(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(SEAT[direction.m_122416_()]);
            shapes.add(BACKREST[direction.m_122416_()]);
            shapes.add(FRONT_SUPPORT[direction.m_122416_()]);
            shapes.add(BACK_SUPPORT[direction.m_122416_()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(BACK_LEFT_LEG[direction.m_122416_()]);
                    shapes.add(FRONT_LEFT_LEG[direction.m_122416_()]);
                    shapes.add(FRONT_RIGHT_LEG[direction.m_122416_()]);
                    shapes.add(BACK_RIGHT_LEG[direction.m_122416_()]);
                    shapes.add(LEFT_SUPPORT[direction.m_122416_()]);
                    shapes.add(RIGHT_SUPPORT[direction.m_122416_()]);
                    break;
                }
                case LEFT: {
                    shapes.add(BACK_LEFT_LEG[direction.m_122416_()]);
                    shapes.add(FRONT_LEFT_LEG[direction.m_122416_()]);
                    shapes.add(LEFT_SUPPORT[direction.m_122416_()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(FRONT_RIGHT_LEG[direction.m_122416_()]);
                    shapes.add(BACK_RIGHT_LEG[direction.m_122416_()]);
                    shapes.add(RIGHT_SUPPORT[direction.m_122416_()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        return SeatEntity.create(level, pos, 0.3375, playerEntity);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return this.getBenchState(state, (LevelAccessor)context.m_43725_(), context.m_8083_(), (Direction)state.m_61143_((Property)DIRECTION));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getBenchState(state, level, pos, (Direction)state.m_61143_((Property)DIRECTION));
    }

    private BlockState getBenchState(BlockState state, LevelAccessor level, BlockPos pos, Direction dir) {
        boolean left = this.isBench(level, pos, dir.m_122428_(), dir);
        boolean right = this.isBench(level, pos, dir.m_122427_(), dir);
        if (left && right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isBench(LevelAccessor level, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = level.m_8055_(source.m_142300_(direction));
        if (state.m_60734_() == this) {
            Direction sofaDirection = (Direction)state.m_61143_((Property)DIRECTION);
            return sofaDirection.equals((Object)targetDirection);
        }
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

