/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.messages;

import de.srendi.advancedperipherals.common.blocks.tileentity.ARControllerTile;
import de.srendi.advancedperipherals.network.MNetwork;
import de.srendi.advancedperipherals.network.messages.UpdateHudCanvasMessage;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class RequestHudCanvasMessage {
    private BlockPos blockPos;
    private String dimensionKey;

    public RequestHudCanvasMessage(BlockPos blockPos, String dimensionKey) {
        this.blockPos = blockPos;
        this.dimensionKey = dimensionKey;
    }

    public static RequestHudCanvasMessage decode(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.m_130135_();
        String dimensionKey = buf.m_130136_(Short.MAX_VALUE);
        return new RequestHudCanvasMessage(blockPos, dimensionKey);
    }

    public static void encode(RequestHudCanvasMessage mes, FriendlyByteBuf buf) {
        buf.m_130064_(mes.getBlockPos());
        buf.m_130072_(mes.getDimensionKey(), Short.MAX_VALUE);
    }

    public static void handle(RequestHudCanvasMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> {
            Iterable worlds = ((NetworkEvent.Context)cont.get()).getSender().m_20194_().m_129785_();
            for (ServerLevel world : worlds) {
                if (!world.m_46472_().toString().equals(mes.getDimensionKey())) continue;
                BlockEntity te = world.m_7702_(mes.getBlockPos());
                if (!(te instanceof ARControllerTile)) {
                    return;
                }
                ARControllerTile controller = (ARControllerTile)te;
                MNetwork.sendTo(new UpdateHudCanvasMessage(controller.getCanvas()), ((NetworkEvent.Context)cont.get()).getSender());
                break;
            }
        });
        cont.get().setPacketHandled(true);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public String getDimensionKey() {
        return this.dimensionKey;
    }
}

