/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.village;

import com.mojang.datafixers.util.Pair;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.DesertVillagePools;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.SavannaVillagePools;
import net.minecraft.data.worldgen.SnowyVillagePools;
import net.minecraft.data.worldgen.TaigaVillagePools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;

public class VillageStructures {
    public static void init() {
        if (!((Boolean)APConfig.WORLD_CONFIG.ENABLE_VILLAGER_STRUCTURES.get()).booleanValue()) {
            return;
        }
        PlainVillagePools.m_127185_();
        SavannaVillagePools.m_127230_();
        TaigaVillagePools.m_127305_();
        DesertVillagePools.m_126860_();
        SnowyVillagePools.m_127233_();
        for (String biome : new String[]{"desert", "snowy", "plains", "savanna", "taiga"}) {
            AdvancedPeripherals.debug("Register generating scientist_" + biome + " village house");
            VillageStructures.addToPool(new ResourceLocation("village/" + biome + "/houses"), "advancedperipherals:villages/scientist_" + biome, (Integer)APConfig.WORLD_CONFIG.VILLAGER_STRUCTURE_WEIGHT.get());
        }
    }

    private static void addToPool(ResourceLocation pool, String toAdd, int weight) {
        StructureTemplatePool old = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        if (old == null) {
            AdvancedPeripherals.debug("no jigsaw pool for " + pool + "? skipping villager house generation for it");
            return;
        }
        List shuffled = old.m_69276_((Random)ThreadLocalRandom.current());
        List newPieces = shuffled.stream().map(p -> Pair.of((Object)p, (Object)1)).collect(Collectors.toList());
        StructurePoolElement newPiece = (StructurePoolElement)StructurePoolElement.m_69192_((String)toAdd).apply(StructureTemplatePool.Projection.RIGID);
        newPieces.add(Pair.of((Object)newPiece, (Object)weight));
        Registry.m_122965_((Registry)BuiltinRegistries.f_123864_, (ResourceLocation)pool, (Object)new StructureTemplatePool(pool, old.m_69275_(), newPieces));
        AdvancedPeripherals.debug("Finished registration for " + toAdd);
    }
}

