/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;

public class LuaConverter {
    public static Map<String, Object> entityToLua(Entity entity) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", entity.m_142049_());
        data.put("uuid", entity.m_20149_());
        data.put("name", entity.m_7755_().getString());
        data.put("tags", entity.m_19880_());
        return data;
    }

    public static Map<String, Object> animalToLua(Animal animal, ItemStack itemInHand) {
        Map<String, Object> data = LuaConverter.entityToLua((Entity)animal);
        data.put("baby", animal.m_6162_());
        data.put("inLove", animal.m_27593_());
        data.put("aggressive", animal.m_5912_());
        if (animal instanceof IForgeShearable) {
            IForgeShearable shareable = (IForgeShearable)animal;
            if (!itemInHand.m_41619_()) {
                data.put("shareable", shareable.isShearable(itemInHand, animal.f_19853_, animal.m_142538_()));
            }
        }
        return data;
    }

    public static Map<String, Object> completeEntityToLua(Entity entity, ItemStack itemInHand) {
        if (entity instanceof Animal) {
            return LuaConverter.animalToLua((Animal)entity, itemInHand);
        }
        return LuaConverter.entityToLua(entity);
    }

    public static Map<String, Object> completeEntityWithPositionToLua(Entity entity, ItemStack itemInHand, BlockPos pos) {
        Map<String, Object> data = LuaConverter.completeEntityToLua(entity, itemInHand);
        data.put("x", entity.m_20185_() - (double)pos.m_123341_());
        data.put("y", entity.m_20186_() - (double)pos.m_123342_());
        data.put("z", entity.m_20189_() - (double)pos.m_123343_());
        return data;
    }

    public static Object posToObject(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", pos.m_123341_());
        map.put("y", pos.m_123342_());
        map.put("z", pos.m_123343_());
        return map;
    }

    public static Map<String, Object> stackToObject(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = LuaConverter.itemToObject(stack.m_41720_());
        CompoundTag nbt = stack.m_41783_();
        map.put("count", stack.m_41613_());
        map.put("displayName", stack.m_41611_().getString());
        map.put("maxStackSize", stack.m_41741_());
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        map.put("nbt", NBTUtil.toLua((Tag)nbt));
        return map;
    }

    public static Map<String, Object> itemToObject(@NotNull Item item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tags", LuaConverter.tagsToList(item.getTags()));
        map.put("name", item.getRegistryName().toString());
        return map;
    }

    public static List<String> tagsToList(@NotNull Set<ResourceLocation> tags) {
        if (tags.isEmpty()) {
            return null;
        }
        return tags.stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static Direction getDirection(Direction facing, String computerSide) throws LuaException {
        if (Direction.m_122402_((String)computerSide) != null) {
            return Direction.m_122402_((String)computerSide);
        }
        if (Objects.equals(computerSide, ComputerSide.FRONT.toString())) {
            return facing;
        }
        if (Objects.equals(computerSide, ComputerSide.BACK.toString())) {
            return facing.m_122424_();
        }
        if (Objects.equals(computerSide, ComputerSide.TOP.toString())) {
            return Direction.UP;
        }
        if (Objects.equals(computerSide, ComputerSide.BOTTOM.toString())) {
            return Direction.DOWN;
        }
        if (Objects.equals(computerSide, ComputerSide.RIGHT.toString())) {
            return facing.m_122428_();
        }
        if (Objects.equals(computerSide, ComputerSide.LEFT.toString())) {
            return facing.m_122427_();
        }
        throw new LuaException(computerSide + " is not a valid side");
    }

    public static BlockPos convertToBlockPos(Map<?, ?> table) throws LuaException {
        if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
            throw new LuaException("Table should be block position table");
        }
        Object x = table.get("x");
        Object y = table.get("y");
        Object z = table.get("z");
        if (!(x instanceof Number && y instanceof Number && z instanceof Number)) {
            throw new LuaException("Table should be block position table");
        }
        return new BlockPos(((Number)x).intValue(), ((Number)y).intValue(), ((Number)z).intValue());
    }

    public static BlockPos convertToBlockPos(BlockPos center, Map<?, ?> table) throws LuaException {
        BlockPos relative = LuaConverter.convertToBlockPos(table);
        return new BlockPos(center.m_123341_() + relative.m_123341_(), center.m_123342_() + relative.m_123342_(), center.m_123343_() + relative.m_123343_());
    }
}

