/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import appeng.api.storage.MEStorage;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

public class ItemUtil {
    @ObjectHolder(value="computercraft:turtle_normal")
    public static Item TURTLE_NORMAL;
    @ObjectHolder(value="computercraft:turtle_advanced")
    public static Item TURTLE_ADVANCED;
    @ObjectHolder(value="computercraft:pocket_computer_normal")
    public static Item POCKET_NORMAL;
    @ObjectHolder(value="computercraft:pocket_computer_advanced")
    public static Item POCKET_ADVANCED;

    public static <T extends ForgeRegistryEntry<T>> T getRegistryEntry(String name, IForgeRegistry<T> forgeRegistry) {
        ForgeRegistryEntry value;
        ResourceLocation location;
        try {
            location = new ResourceLocation(name);
        }
        catch (ResourceLocationException ex) {
            location = null;
        }
        if (location != null && forgeRegistry.containsKey(location) && (value = (ForgeRegistryEntry)forgeRegistry.getValue(location)) != null) {
            return (T)value;
        }
        return null;
    }

    public static ItemStack makeTurtle(Item turtle, String upgrade) {
        ItemStack stack = new ItemStack((ItemLike)turtle);
        stack.m_41784_().m_128359_("RightUpgrade", upgrade);
        return stack;
    }

    public static ItemStack makePocket(Item turtle, String upgrade) {
        ItemStack stack = new ItemStack((ItemLike)turtle);
        stack.m_41784_().m_128359_("Upgrade", upgrade);
        return stack;
    }

    public static ItemStack getItemStack(Map<?, ?> table, MEStorage monitor) throws LuaException {
        if (table == null || table.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (table.containsKey("fingerprint")) {
            ItemStack fingerprint = AppEngApi.findMatchingFingerprint(TableHelper.getStringField(table, (String)"fingerprint"), monitor);
            if (table.containsKey("count")) {
                fingerprint.m_41764_(TableHelper.getIntField(table, (String)"count"));
            }
            return fingerprint;
        }
        if (!table.containsKey("name")) {
            return ItemStack.f_41583_;
        }
        String name = TableHelper.getStringField(table, (String)"name");
        Item item = (Item)ItemUtil.getRegistryEntry(name, ForgeRegistries.ITEMS);
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        if (table.containsKey("count")) {
            stack.m_41764_(TableHelper.getIntField(table, (String)"count"));
        }
        if (table.containsKey("nbt") || table.containsKey("json") || table.containsKey("tag")) {
            stack.m_41751_(ItemUtil.getTag(stack, table, monitor));
        }
        return stack;
    }

    private static CompoundTag getTag(ItemStack stack, Map<?, ?> table, MEStorage monitor) throws LuaException {
        CompoundTag nbt = NBTUtil.fromText(TableHelper.optStringField(table, (String)"json", null));
        if (nbt == null && (nbt = NBTUtil.fromBinary(TableHelper.optStringField(table, (String)"tag", null))) == null) {
            nbt = ItemUtil.parseNBTHash(stack, table, monitor);
        }
        return nbt;
    }

    private static CompoundTag parseNBTHash(ItemStack stack, Map<?, ?> table, MEStorage monitor) throws LuaException {
        String nbt = TableHelper.optStringField(table, (String)"nbt", null);
        if (nbt == null || nbt.isEmpty()) {
            return null;
        }
        CompoundTag tag = AppEngApi.findMatchingTag(stack, nbt, monitor);
        if (tag != null) {
            return tag;
        }
        tag = new CompoundTag();
        tag.m_128365_("_apPlaceholder_", (Tag)IntTag.m_128679_((int)1));
        return tag;
    }
}

