/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.blocks.base.IInventoryBlock;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PeripheralTileEntity<T extends BasePeripheral<?>>
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
IPeripheralTileEntity {
    private static final String PERIPHERAL_SETTINGS_KEY = "peripheralSettings";
    protected CompoundTag peripheralSettings;
    protected NonNullList<ItemStack> items = this instanceof IInventoryBlock ? NonNullList.m_122780_((int)((IInventoryBlock)((Object)this)).getInvSize(), (Object)ItemStack.f_41583_) : NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
    @Nullable
    protected T peripheral = null;
    private LazyOptional<? extends IItemHandler> handler;
    private LazyOptional<IPeripheral> peripheralCap;

    public PeripheralTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.peripheralSettings = new CompoundTag();
    }

    @NotNull
    public <T1> LazyOptional<T1> getCapability(@NotNull Capability<T1> cap, @Nullable Direction direction) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheral == null) {
                this.peripheral = this.createPeripheral();
            }
            if (this.peripheral.isEnabled()) {
                if (this.peripheralCap == null) {
                    this.peripheralCap = LazyOptional.of(() -> this.peripheral);
                } else if (!this.peripheralCap.isPresent()) {
                    this.peripheral = this.createPeripheral();
                    this.peripheralCap = LazyOptional.of(() -> this.peripheral);
                }
                return this.peripheralCap.cast();
            }
            AdvancedPeripherals.debug(((BasePeripheral)this.peripheral).getType() + " is disabled, you can enable it in the Configuration.");
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !this.f_58859_ && direction != null && this instanceof IInventoryBlock) {
            if (this.handler == null || !this.handler.isPresent()) {
                this.handler = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.NORTH));
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.peripheralCap != null) {
            this.peripheralCap.invalidate();
        }
        if (this.handler != null) {
            this.handler.invalidate();
        }
    }

    @NotNull
    protected abstract T createPeripheral();

    public List<IComputerAccess> getConnectedComputers() {
        if (this.peripheral == null) {
            return Collections.emptyList();
        }
        return ((BasePeripheral)this.peripheral).getConnectedComputers();
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        if (!this.peripheralSettings.m_128456_()) {
            compound.m_128365_(PERIPHERAL_SETTINGS_KEY, (Tag)this.peripheralSettings);
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        this.peripheralSettings = compound.m_128469_(PERIPHERAL_SETTINGS_KEY);
        super.m_142466_(compound);
    }

    protected Component m_6820_() {
        return this instanceof IInventoryBlock ? ((IInventoryBlock)((Object)this)).getDisplayName() : null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player playerEntity) {
        return this.m_6555_(id, inventory);
    }

    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        return this instanceof IInventoryBlock ? (AbstractContainerMenu)((IInventoryBlock)((Object)this)).createContainer(id, player, this.f_58858_, this.f_58857_) : null;
    }

    public int[] m_7071_(@NotNull Direction side) {
        return new int[]{0};
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public CompoundTag getPeripheralSettings() {
        return this.peripheralSettings;
    }

    @Override
    public void markSettingsChanged() {
        this.m_6596_();
    }
}

