/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.argoggles;

import com.mojang.blaze3d.vertex.PoseStack;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.argoggles.ARRenderHelper;
import de.srendi.advancedperipherals.common.argoggles.RenderActionType;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public final class ARRenderAction
implements INBTSerializable<CompoundTag> {
    private static final String TYPE = "type";
    private static final String STRING_ARG = "string_arg";
    private static final String INT_ARGS = "int_args";
    private static final String VIRTUAL_SCREEN_SIZE = "virtualScreenSize";
    private RenderActionType type;
    private String stringArg = "";
    private int[] intArgs = new int[0];
    private Optional<int[]> virtualScreenSize = Optional.empty();

    public ARRenderAction() {
    }

    public ARRenderAction(RenderActionType type, int ... intArgs) {
        this();
        this.type = type;
        this.intArgs = intArgs;
    }

    public ARRenderAction(RenderActionType type, String stringArg, int ... intArgs) {
        this(type, intArgs);
        this.stringArg = stringArg;
    }

    public static ARRenderAction deserialize(CompoundTag nbt) {
        ARRenderAction action = new ARRenderAction();
        action.deserializeNBT(nbt);
        return action;
    }

    public void draw(Minecraft mc, PoseStack matrixStack, int w, int h) {
        if (!this.type.ensureArgs(this.intArgs)) {
            return;
        }
        int[] i = this.intArgs;
        switch (this.type) {
            case DrawCenteredString: {
                ARRenderHelper.m_93208_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)this.stringArg, (int)this.relativeX(i[0], w), (int)this.relativeY(i[1], h), (int)i[2]);
                break;
            }
            case DrawString: {
                ARRenderHelper.m_93236_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)this.stringArg, (int)this.relativeX(i[0], w), (int)this.relativeY(i[1], h), (int)i[2]);
                break;
            }
            case DrawRightboundString: {
                ARRenderHelper.drawRightboundString(matrixStack, mc.f_91062_, this.stringArg, this.relativeX(i[0], w), this.relativeY(i[1], h), i[2]);
                break;
            }
            case Fill: {
                i[4] = ARRenderHelper.fixAlpha(i[4]);
                ARRenderHelper.m_93172_((PoseStack)matrixStack, (int)this.relativeX(i[0], w), (int)this.relativeY(i[1], h), (int)this.relativeX(i[2], w), (int)this.relativeY(i[3], h), (int)i[4]);
                break;
            }
            case HorizontalLine: {
                ARRenderHelper.getInstance().m_93154_(matrixStack, this.relativeX(i[0], w), this.relativeX(i[1], w), this.relativeY(i[2], h), i[3]);
                break;
            }
            case VerticalLine: {
                ARRenderHelper.getInstance().m_93222_(matrixStack, this.relativeX(i[0], w), this.relativeY(i[1], h), this.relativeY(i[2], h), i[3]);
                break;
            }
            case FillGradient: {
                ARRenderHelper.getInstance().m_93179_(matrixStack, this.relativeX(i[0], w), this.relativeY(i[1], h), this.relativeX(i[2], w), this.relativeY(i[3], h), i[4], i[5]);
                break;
            }
            case DrawCircle: {
                ARRenderHelper.getInstance().drawCircle(matrixStack, this.relativeX(i[0], w), this.relativeY(i[1], h), this.relativeAverage(i[2], w, h), i[3]);
                break;
            }
            case FillCircle: {
                ARRenderHelper.getInstance().fillCircle(matrixStack, this.relativeX(i[0], w), this.relativeY(i[1], h), this.relativeAverage(i[2], w, h), i[3]);
                break;
            }
            case DrawItemIcon: {
                ARRenderHelper.getInstance().drawItemIcon(matrixStack, mc.m_91291_(), this.stringArg, this.relativeX(i[0], w), this.relativeY(i[1], h));
                break;
            }
            default: {
                AdvancedPeripherals.LOGGER.warn("Failed to execute AR render action of unimplemented type " + this.type);
            }
        }
    }

    private int relativeX(int x, int windowWidth) {
        if (this.virtualScreenSize.isPresent()) {
            x = x >= 0 ? x : this.virtualScreenSize.get()[0] + x;
            return (int)Math.round((double)x / (double)this.virtualScreenSize.get()[0] * (double)windowWidth);
        }
        return x >= 0 ? x : windowWidth + x;
    }

    private int relativeY(int y, int windowHeight) {
        if (this.virtualScreenSize.isPresent()) {
            y = y >= 0 ? y : this.virtualScreenSize.get()[1] + y;
            return (int)Math.round((double)y / (double)this.virtualScreenSize.get()[1] * (double)windowHeight);
        }
        return y >= 0 ? y : windowHeight;
    }

    private float relativeAverage(int i, int w, int h) {
        if (this.virtualScreenSize.isPresent()) {
            float xfactor = (float)w / (float)this.virtualScreenSize.get()[0];
            float yfactor = (float)h / (float)this.virtualScreenSize.get()[1];
            return (float)i * (xfactor + yfactor) / 2.0f;
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ARRenderAction) {
            ARRenderAction a = (ARRenderAction)obj;
            return this.type.equals((Object)a.type) && this.stringArg.equals(a.stringArg) && Arrays.equals(this.intArgs, a.intArgs);
        }
        return super.equals(obj);
    }

    public void deserializeNBT(CompoundTag nbt) {
        int[] virtualScreenSizeFromNbt = nbt.m_128465_(VIRTUAL_SCREEN_SIZE);
        this.type = RenderActionType.valueOf(nbt.m_128461_(TYPE));
        this.stringArg = nbt.m_128461_(STRING_ARG);
        this.intArgs = nbt.m_128465_(INT_ARGS);
        this.virtualScreenSize = virtualScreenSizeFromNbt.length == 0 ? Optional.empty() : Optional.of(virtualScreenSizeFromNbt);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TYPE, this.type.toString());
        nbt.m_128359_(STRING_ARG, this.stringArg);
        nbt.m_128385_(INT_ARGS, this.intArgs);
        nbt.m_128385_(VIRTUAL_SCREEN_SIZE, this.virtualScreenSize.orElse(new int[0]));
        return nbt;
    }

    public int[] getVirtualScreenSize() {
        if (this.virtualScreenSize.isPresent()) {
            return this.virtualScreenSize.get();
        }
        return null;
    }

    public void setRelativeMode(int virtualScreenWidth, int virtualScreenHeight) {
        this.virtualScreenSize = Optional.of(new int[]{virtualScreenWidth, virtualScreenHeight});
    }

    public void disableRelativeMode() {
        this.virtualScreenSize = Optional.empty();
    }

    public ARRenderAction copyWithVirtualScreenSize(Optional<int[]> virtualScreenSize2) {
        ARRenderAction action = new ARRenderAction(this.type, this.stringArg, this.intArgs);
        if (virtualScreenSize2.isPresent()) {
            action.setRelativeMode(virtualScreenSize2.get()[0], virtualScreenSize2.get()[1]);
        }
        return action;
    }
}

