/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class AutomataItemSuckPlugin
extends AutomataCorePlugin {
    public AutomataItemSuckPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @Override
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.SUCK};
    }

    protected AABB getBox(BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int interactionRadius = this.automataCore.getInteractionRadius();
        return new AABB((double)(x - interactionRadius), (double)(y - interactionRadius), (double)(z - interactionRadius), (double)(x + interactionRadius), (double)(y + interactionRadius), (double)(z + interactionRadius));
    }

    protected List<ItemEntity> getItems() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        return owner.getLevel().m_45976_(ItemEntity.class, this.getBox(owner.getPos()));
    }

    protected int suckItem(ItemEntity entity, int requiredQuantity) {
        ItemStack leaveStack;
        ItemStack storeStack;
        ItemStack stack = entity.m_32055_().m_41777_();
        if (stack.m_41613_() > requiredQuantity) {
            storeStack = stack.m_41620_(requiredQuantity);
            leaveStack = stack;
        } else {
            storeStack = stack;
            leaveStack = ItemStack.f_41583_;
        }
        ItemStack remainder = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).storeItem(storeStack);
        if (remainder != storeStack) {
            if (remainder.m_41619_() && leaveStack.m_41619_()) {
                entity.m_142687_(Entity.RemovalReason.KILLED);
            } else if (remainder.m_41619_()) {
                entity.m_32045_(leaveStack);
            } else if (leaveStack.m_41619_()) {
                entity.m_32045_(remainder);
            } else {
                leaveStack.m_41769_(remainder.m_41613_());
                entity.m_32045_(leaveStack);
            }
        }
        return requiredQuantity -= storeStack.m_41613_();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scanItems() {
        this.automataCore.addRotationCycle();
        List<ItemEntity> items = this.getItems();
        HashMap data = new HashMap();
        int index = 1;
        for (ItemEntity item : items) {
            HashMap<String, Object> itemData = new HashMap<String, Object>();
            itemData.put("entity_id", item.m_142049_());
            itemData.put("name", item.m_32055_().m_41611_().getString());
            ResourceLocation itemName = item.m_32055_().m_41720_().getRegistryName();
            if (itemName != null) {
                itemData.put("technicalName", itemName.toString());
            }
            itemData.put("count", item.m_32055_().m_41613_());
            itemData.put("tags", item.m_32055_().m_41720_().getTags().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            data.put(index, itemData);
            ++index;
        }
        return MethodResult.of(data);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult collectSpecificItem(@Nonnull IArguments arguments) throws LuaException {
        String technicalName = arguments.getString(0);
        int requiredQuantityArg = arguments.optInt(1, Integer.MAX_VALUE);
        return this.automataCore.withOperation(SingleOperation.SUCK, context -> {
            List<ItemEntity> items = this.getItems();
            int requiredQuantity = requiredQuantityArg;
            for (ItemEntity item : items) {
                ResourceLocation itemName = item.m_32055_().m_41720_().getRegistryName();
                if (itemName == null) continue;
                if (itemName.toString().equals(technicalName)) {
                    requiredQuantity -= this.suckItem(item, requiredQuantity);
                }
                if (requiredQuantity > 0) continue;
                break;
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult collectItems(@Nonnull IArguments arguments) throws LuaException {
        int requiredQuantityArg = arguments.optInt(0, Integer.MAX_VALUE);
        return this.automataCore.withOperation(SingleOperation.SUCK, context -> {
            if (requiredQuantityArg == 0) {
                return MethodResult.of((Object)true);
            }
            List<ItemEntity> items = this.getItems();
            if (items.isEmpty()) {
                return MethodResult.of((Object[])new Object[]{null, "Nothing to take"});
            }
            int requiredQuantity = requiredQuantityArg;
            for (ItemEntity entity : items) {
                if ((requiredQuantity -= this.suckItem(entity, requiredQuantity)) <= 0) break;
            }
            return MethodResult.of((Object)true);
        });
    }
}

