/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class AutomataEntityHandPlugin
extends AutomataCorePlugin {
    private final Predicate<Entity> suitableEntity;

    public AutomataEntityHandPlugin(AutomataCorePeripheral automataCore, Predicate<Entity> suitableEntity) {
        super(automataCore);
        this.suitableEntity = suitableEntity;
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.USE_ON_ANIMAL};
    }

    @LuaFunction(mainThread=true)
    public final MethodResult useOnAnimal() throws LuaException {
        return this.automataCore.withOperation(SingleOperation.USE_ON_ANIMAL, context -> {
            TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
            ItemStack selectedTool = owner.getToolInMainHand();
            int previousDamageValue = selectedTool.m_41773_();
            InteractionResult result = owner.withPlayer(player -> player.useOnFilteredEntity(this.suitableEntity));
            if (this.automataCore.hasAttribute("storingToolDurability")) {
                selectedTool.m_41721_(previousDamageValue);
            }
            return MethodResult.of((Object[])new Object[]{true, result.toString()});
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult inspectAnimal() {
        this.automataCore.addRotationCycle();
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        HitResult entityHit = owner.withPlayer(player -> player.findHit(false, true, this.suitableEntity));
        if (entityHit.m_6662_() == HitResult.Type.MISS) {
            return MethodResult.of((Object[])new Object[]{null, "Nothing found"});
        }
        Entity entity = ((EntityHitResult)entityHit).m_82443_();
        if (!(entity instanceof Animal)) {
            return MethodResult.of((Object[])new Object[]{null, "Well, entity is not animal entity, but how?"});
        }
        return MethodResult.of(LuaConverter.animalToLua((Animal)entity, owner.getToolInMainHand()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult searchAnimals() {
        this.automataCore.addRotationCycle();
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        BlockPos currentPos = owner.getPos();
        AABB box = new AABB(currentPos);
        ArrayList entities = new ArrayList();
        ItemStack itemInHand = owner.getToolInMainHand();
        owner.getLevel().m_6249_((Entity)null, box.m_82400_((double)this.automataCore.getInteractionRadius()), this.suitableEntity).forEach(entity -> entities.add(LuaConverter.completeEntityWithPositionToLua(entity, itemInHand, currentPos)));
        return MethodResult.of(entities);
    }
}

