/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.tileentity.EnergyDetectorTile;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;

public class EnergyDetectorPeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<EnergyDetectorTile>> {
    public static final String TYPE = "energyDetector";

    public EnergyDetectorPeripheral(EnergyDetectorTile tileEntity) {
        super(TYPE, new BlockEntityPeripheralOwner<EnergyDetectorTile>(tileEntity));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_ENERGY_DETECTOR.get();
    }

    @LuaFunction(mainThread=true)
    public final int getTransferRateLimit() {
        return ((EnergyDetectorTile)((BlockEntityPeripheralOwner)this.owner).tileEntity).storageProxy.getMaxTransferRate();
    }

    @LuaFunction(mainThread=true)
    public final void setTransferRateLimit(long transferRate) {
        transferRate = Math.min((long)((Integer)APConfig.PERIPHERALS_CONFIG.ENERGY_DETECTOR_MAX_FLOW.get()).intValue(), transferRate);
        ((EnergyDetectorTile)((BlockEntityPeripheralOwner)this.owner).tileEntity).storageProxy.setMaxTransferRate((int)transferRate);
    }

    @LuaFunction(mainThread=true)
    public final int getTransferRate() {
        return ((EnergyDetectorTile)((BlockEntityPeripheralOwner)this.owner).tileEntity).transferRate;
    }
}

