/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SimpleFreeOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ChatBoxPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String TYPE = "chatBox";

    protected ChatBoxPeripheral(IPeripheralOwner owner) {
        super(TYPE, owner);
        owner.attachOperation(SimpleFreeOperation.CHAT_MESSAGE);
    }

    public ChatBoxPeripheral(PeripheralTileEntity<?> tileEntity) {
        this(new BlockEntityPeripheralOwner(tileEntity));
    }

    public ChatBoxPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side));
    }

    public ChatBoxPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_CHAT_BOX.get();
    }

    protected MethodResult withChatOperation(IPeripheralFunction<Object, MethodResult> function) throws LuaException {
        return this.withOperation(SimpleFreeOperation.CHAT_MESSAGE, null, null, function, null);
    }

    private MutableComponent appendPrefix(String prefix, String brackets, String color) {
        TextComponent prefixComponent = new TextComponent((String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get());
        if (!prefix.isEmpty()) {
            try {
                MutableComponent formattablePrefix = Component.Serializer.m_130701_((String)prefix);
                prefixComponent = (TextComponent)formattablePrefix;
            }
            catch (JsonSyntaxException exception) {
                AdvancedPeripherals.debug("Non json prefix, using plain text instead.");
                prefixComponent = new TextComponent(prefix);
            }
        }
        if (brackets.isEmpty()) {
            brackets = "[]";
        }
        return new TextComponent(color + brackets.charAt(0) + "\u00a7r").m_7220_((Component)prefixComponent).m_130946_(color + brackets.charAt(1) + "\u00a7r ");
    }

    private ServerPlayer getPlayer(String argument) {
        if (argument.matches("\\b[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\b")) {
            return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(argument));
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(argument);
    }

    private boolean checkBrackets(Optional<String> brackets) {
        return brackets.isPresent() && brackets.get().length() != 2;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessage(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            int range = arguments.optInt(4, -1);
            MutableComponent component = Component.Serializer.m_130701_((String)message);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            if (this.checkBrackets(arguments.optString(2))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(arguments.optString(1, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(2, "[]"), arguments.optString(3, "")).m_7220_((Component)component);
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                if (range != -1) {
                    if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range)) continue;
                    player.m_6352_((Component)preparedMessage, Util.f_137441_);
                    continue;
                }
                player.m_6352_((Component)preparedMessage, Util.f_137441_);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessage(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            int range = arguments.optInt(4, -1);
            if (this.checkBrackets(arguments.optString(2))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(arguments.optString(1, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(2, "[]"), arguments.optString(3, "")).m_130946_(message);
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                if (range != -1) {
                    if (!CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range)) continue;
                    player.m_6352_((Component)preparedMessage, Util.f_137441_);
                    continue;
                }
                player.m_6352_((Component)preparedMessage, Util.f_137441_);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessageToPlayer(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String playerName = arguments.getString(1);
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            MutableComponent component = Component.Serializer.m_130701_((String)message);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            if (this.checkBrackets(arguments.optString(3))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(arguments.optString(2, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(3, "[]"), arguments.optString(4, "")).m_7220_((Component)component);
            player.m_6352_((Component)preparedMessage, Util.f_137441_);
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessageToPlayer(@Nonnull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String playerName = arguments.getString(1);
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            if (this.checkBrackets(arguments.optString(3))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(arguments.optString(2, (String)APConfig.PERIPHERALS_CONFIG.DEFAULT_CHAT_BOX_PREFIX.get()), arguments.optString(3, "[]"), arguments.optString(4, "")).m_130946_(message);
            player.m_6352_((Component)preparedMessage, Util.f_137441_);
            return MethodResult.of((Object)true);
        });
    }
}

