/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureSpawnManager {
    private static Map<StructureFeature<?>, StructureSpawnInfo> structuresWithSpawns = Collections.emptyMap();

    public static void gatherEntitySpawns() {
        LinkedHashMap structuresWithSpawns = new LinkedHashMap();
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, StructureFeature.f_67021_);
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, StructureFeature.f_67013_);
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, StructureFeature.f_67023_);
        StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, StructureFeature.f_67025_);
        for (StructureFeature<?> structure : ForgeRegistries.STRUCTURE_FEATURES.getValues()) {
            if (structure == StructureFeature.f_67021_ || structure == StructureFeature.f_67013_ || structure == StructureFeature.f_67023_ || structure == StructureFeature.f_67025_) continue;
            StructureSpawnManager.gatherEntitySpawns(structuresWithSpawns, structure);
        }
        StructureSpawnManager.structuresWithSpawns = structuresWithSpawns;
    }

    private static void gatherEntitySpawns(Map<StructureFeature<?>, StructureSpawnInfo> structuresWithSpawns, StructureFeature<?> structure) {
        StructureSpawnListGatherEvent event = new StructureSpawnListGatherEvent(structure);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        event.getEntitySpawns().forEach((classification, spawns) -> {
            if (!spawns.isEmpty()) {
                builder.put(classification, (Object)WeightedRandomList.m_146328_((List)spawns));
            }
        });
        ImmutableMap entitySpawns = builder.build();
        if (!entitySpawns.isEmpty()) {
            structuresWithSpawns.put(structure, new StructureSpawnInfo((ImmutableMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>>)entitySpawns, event.isInsideOnly()));
        }
    }

    @Nullable
    public static WeightedRandomList<MobSpawnSettings.SpawnerData> getStructureSpawns(StructureFeatureManager structureManager, MobCategory classification, BlockPos pos) {
        for (Map.Entry<StructureFeature<?>, StructureSpawnInfo> entry : structuresWithSpawns.entrySet()) {
            boolean valid;
            StructureFeature<?> structure = entry.getKey();
            StructureSpawnInfo spawnInfo = entry.getValue();
            if (!spawnInfo.spawns.containsKey(classification) || !(valid = spawnInfo.insideOnly ? structureManager.m_186613_(pos, structure).m_73603_() : structureManager.m_186607_(pos, structure).m_73603_())) continue;
            return spawnInfo.spawns.get(classification);
        }
        return null;
    }

    public static WeightedRandomList<MobSpawnSettings.SpawnerData> getSpawnList(StructureFeature<?> structure, MobCategory classification) {
        StructureSpawnInfo info = structuresWithSpawns.get(structure);
        if (info != null) {
            return info.spawns.getOrDefault(classification, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.m_146332_());
        }
        return WeightedRandomList.m_146332_();
    }

    private static class StructureSpawnInfo {
        private final Map<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> spawns;
        private final boolean insideOnly;

        private StructureSpawnInfo(ImmutableMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> spawns, boolean insideOnly) {
            this.spawns = spawns;
            this.insideOnly = insideOnly;
        }
    }
}

