/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModifierManager
extends SimpleJsonResourceReloadListener {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON_INSTANCE = Deserializers.m_78799_().create();
    private Map<ResourceLocation, IGlobalLootModifier> registeredLootModifiers = ImmutableMap.of();
    private static final String folder = "loot_modifiers";

    public LootModifierManager() {
        super(GSON_INSTANCE, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(Map<ResourceLocation, JsonElement> resourceList, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ImmutableMap immutablemap;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ArrayList<ResourceLocation> finalLocations = new ArrayList<ResourceLocation>();
        ResourceLocation resourcelocation = new ResourceLocation("forge", "loot_modifiers/global_loot_modifiers.json");
        try {
            for (Resource iresource : resourceManagerIn.m_7396_(resourcelocation)) {
                try {
                    InputStream inputstream = iresource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonObject jsonobject = (JsonObject)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                        boolean replace = jsonobject.get("replace").getAsBoolean();
                        if (replace) {
                            finalLocations.clear();
                        }
                        JsonArray entryList = jsonobject.get("entries").getAsJsonArray();
                        for (JsonElement entry : entryList) {
                            String loc = entry.getAsString();
                            ResourceLocation res = new ResourceLocation(loc);
                            if (finalLocations.contains(res)) {
                                finalLocations.remove(res);
                            }
                            finalLocations.add(res);
                        }
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                catch (IOException | RuntimeException ioexception) {
                    LOGGER.error("Couldn't read global loot modifier list {} in data pack {}", (Object)resourcelocation, (Object)iresource.m_7816_(), (Object)ioexception);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
            }
        }
        catch (IOException ioexception1) {
            LOGGER.error("Couldn't read global loot modifier list from {}", (Object)resourcelocation, (Object)ioexception1);
        }
        finalLocations.forEach(location -> {
            try {
                IGlobalLootModifier modifier = this.deserializeModifier((ResourceLocation)location, (JsonElement)resourceList.get(location));
                if (modifier != null) {
                    builder.put(location, (Object)modifier);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse loot modifier {}", location, (Object)exception);
            }
        });
        this.registeredLootModifiers = immutablemap = builder.build();
    }

    private IGlobalLootModifier deserializeModifier(ResourceLocation location, JsonElement element) {
        if (!element.isJsonObject()) {
            return null;
        }
        JsonObject object = element.getAsJsonObject();
        LootItemCondition[] lootConditions = (LootItemCondition[])GSON_INSTANCE.fromJson(object.get("conditions"), LootItemCondition[].class);
        ResourceLocation serializer = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type"));
        return ForgeRegistries.LOOT_MODIFIER_SERIALIZERS.getValue(serializer).read(location, object, lootConditions);
    }

    public static GlobalLootModifierSerializer<?> getSerializerForName(ResourceLocation resourcelocation) {
        return ForgeRegistries.LOOT_MODIFIER_SERIALIZERS.getValue(resourcelocation);
    }

    public Collection<IGlobalLootModifier> getAllLootMods() {
        return this.registeredLootModifiers.values();
    }
}

