/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public final class ForgeBlockTagsProvider
extends BlockTagsProvider {
    public ForgeBlockTagsProvider(DataGenerator gen, ExistingFileHelper existingFileHelper) {
        super(gen, "forge", existingFileHelper);
    }

    public void m_6577_() {
        this.m_126548_(Tags.Blocks.BARRELS).m_126580_(Tags.Blocks.BARRELS_WOODEN);
        this.m_126548_(Tags.Blocks.BARRELS_WOODEN).m_126582_((Object)Blocks.f_50618_);
        this.m_126548_(Tags.Blocks.CHESTS).addTags(new Tag.Named[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Tags.Blocks.CHESTS_WOODEN});
        this.m_126548_(Tags.Blocks.CHESTS_ENDER).m_126582_((Object)Blocks.f_50265_);
        this.m_126548_(Tags.Blocks.CHESTS_TRAPPED).m_126582_((Object)Blocks.f_50325_);
        this.m_126548_(Tags.Blocks.CHESTS_WOODEN).m_126584_((Object[])new Block[]{Blocks.f_50087_, Blocks.f_50325_});
        this.m_126548_(Tags.Blocks.COBBLESTONE).addTags(new Tag.Named[]{Tags.Blocks.COBBLESTONE_NORMAL, Tags.Blocks.COBBLESTONE_INFESTED, Tags.Blocks.COBBLESTONE_MOSSY, Tags.Blocks.COBBLESTONE_DEEPSLATE});
        this.m_126548_(Tags.Blocks.COBBLESTONE_NORMAL).m_126582_((Object)Blocks.f_50652_);
        this.m_126548_(Tags.Blocks.COBBLESTONE_INFESTED).m_126582_((Object)Blocks.f_50227_);
        this.m_126548_(Tags.Blocks.COBBLESTONE_MOSSY).m_126582_((Object)Blocks.f_50079_);
        this.m_126548_(Tags.Blocks.COBBLESTONE_DEEPSLATE).m_126582_((Object)Blocks.f_152551_);
        this.m_126548_(Tags.Blocks.END_STONES).m_126582_((Object)Blocks.f_50259_);
        this.m_126548_(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST);
        this.m_126548_(Tags.Blocks.FENCE_GATES).addTags(new Tag.Named[]{Tags.Blocks.FENCE_GATES_WOODEN});
        this.m_126548_(Tags.Blocks.FENCE_GATES_WOODEN).m_126584_((Object[])new Block[]{Blocks.f_50192_, Blocks.f_50474_, Blocks.f_50475_, Blocks.f_50476_, Blocks.f_50477_, Blocks.f_50478_, Blocks.f_50665_, Blocks.f_50666_});
        this.m_126548_(Tags.Blocks.FENCES).addTags(new Tag.Named[]{Tags.Blocks.FENCES_NETHER_BRICK, Tags.Blocks.FENCES_WOODEN});
        this.m_126548_(Tags.Blocks.FENCES_NETHER_BRICK).m_126582_((Object)Blocks.f_50198_);
        this.m_126548_(Tags.Blocks.FENCES_WOODEN).m_126580_(BlockTags.f_13098_);
        this.m_126548_(Tags.Blocks.GLASS).addTags(new Tag.Named[]{Tags.Blocks.GLASS_COLORLESS, Tags.Blocks.STAINED_GLASS, Tags.Blocks.GLASS_TINTED});
        this.m_126548_(Tags.Blocks.GLASS_COLORLESS).m_126582_((Object)Blocks.f_50058_);
        this.m_126548_(Tags.Blocks.GLASS_SILICA).m_126584_((Object[])new Block[]{Blocks.f_50058_, Blocks.f_50215_, Blocks.f_50211_, Blocks.f_50212_, Blocks.f_50209_, Blocks.f_50207_, Blocks.f_50213_, Blocks.f_50203_, Blocks.f_50208_, Blocks.f_50205_, Blocks.f_50202_, Blocks.f_50148_, Blocks.f_50206_, Blocks.f_50210_, Blocks.f_50214_, Blocks.f_50147_, Blocks.f_50204_});
        this.m_126548_(Tags.Blocks.GLASS_TINTED).m_126582_((Object)Blocks.f_152498_);
        this.addColored(arg_0 -> ((TagsProvider.TagAppender)this.m_126548_(Tags.Blocks.STAINED_GLASS)).m_126582_(arg_0), Tags.Blocks.GLASS, "{color}_stained_glass");
        this.m_126548_(Tags.Blocks.GLASS_PANES).addTags(new Tag.Named[]{Tags.Blocks.GLASS_PANES_COLORLESS, Tags.Blocks.STAINED_GLASS_PANES});
        this.m_126548_(Tags.Blocks.GLASS_PANES_COLORLESS).m_126582_((Object)Blocks.f_50185_);
        this.addColored(arg_0 -> ((TagsProvider.TagAppender)this.m_126548_(Tags.Blocks.STAINED_GLASS_PANES)).m_126582_(arg_0), Tags.Blocks.GLASS_PANES, "{color}_stained_glass_pane");
        this.m_126548_(Tags.Blocks.GRAVEL).m_126582_((Object)Blocks.f_49994_);
        this.m_126548_(Tags.Blocks.NETHERRACK).m_126582_((Object)Blocks.f_50134_);
        this.m_126548_(Tags.Blocks.OBSIDIAN).m_126582_((Object)Blocks.f_50080_);
        this.m_126548_(Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE).m_126582_((Object)Blocks.f_152550_);
        this.m_126548_(Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK).m_126582_((Object)Blocks.f_50134_);
        this.m_126548_(Tags.Blocks.ORE_BEARING_GROUND_STONE).m_126582_((Object)Blocks.f_50069_);
        this.m_126548_(Tags.Blocks.ORE_RATES_DENSE).m_126584_((Object[])new Block[]{Blocks.f_152505_, Blocks.f_152506_, Blocks.f_152472_, Blocks.f_152473_, Blocks.f_50059_, Blocks.f_50173_});
        this.m_126548_(Tags.Blocks.ORE_RATES_SINGULAR).m_126584_((Object[])new Block[]{Blocks.f_50722_, Blocks.f_49997_, Blocks.f_152469_, Blocks.f_152474_, Blocks.f_152479_, Blocks.f_152467_, Blocks.f_152468_, Blocks.f_50089_, Blocks.f_50264_, Blocks.f_49995_, Blocks.f_49996_, Blocks.f_50331_});
        this.m_126548_(Tags.Blocks.ORE_RATES_SPARSE).m_126582_((Object)Blocks.f_49998_);
        this.m_126548_(Tags.Blocks.ORES).addTags(new Tag.Named[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_COPPER, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_REDSTONE, Tags.Blocks.ORES_QUARTZ, Tags.Blocks.ORES_NETHERITE_SCRAP});
        this.m_126548_(Tags.Blocks.ORES_COAL).m_126580_(BlockTags.f_144262_);
        this.m_126548_(Tags.Blocks.ORES_COPPER).m_126580_(BlockTags.f_144264_);
        this.m_126548_(Tags.Blocks.ORES_DIAMOND).m_126580_(BlockTags.f_144259_);
        this.m_126548_(Tags.Blocks.ORES_EMERALD).m_126580_(BlockTags.f_144263_);
        this.m_126548_(Tags.Blocks.ORES_GOLD).m_126580_(BlockTags.f_13043_);
        this.m_126548_(Tags.Blocks.ORES_IRON).m_126580_(BlockTags.f_144258_);
        this.m_126548_(Tags.Blocks.ORES_LAPIS).m_126580_(BlockTags.f_144261_);
        this.m_126548_(Tags.Blocks.ORES_QUARTZ).m_126582_((Object)Blocks.f_50331_);
        this.m_126548_(Tags.Blocks.ORES_REDSTONE).m_126580_(BlockTags.f_144260_);
        this.m_126548_(Tags.Blocks.ORES_NETHERITE_SCRAP).m_126582_((Object)Blocks.f_50722_);
        this.m_126548_(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE).m_126584_((Object[])new Block[]{Blocks.f_152469_, Blocks.f_152506_, Blocks.f_152474_, Blocks.f_152479_, Blocks.f_152467_, Blocks.f_152468_, Blocks.f_152472_, Blocks.f_152473_});
        this.m_126548_(Tags.Blocks.ORES_IN_GROUND_NETHERRACK).m_126584_((Object[])new Block[]{Blocks.f_49998_, Blocks.f_50331_});
        this.m_126548_(Tags.Blocks.ORES_IN_GROUND_STONE).m_126584_((Object[])new Block[]{Blocks.f_49997_, Blocks.f_152505_, Blocks.f_50089_, Blocks.f_50264_, Blocks.f_49995_, Blocks.f_49996_, Blocks.f_50059_, Blocks.f_50173_});
        this.m_126548_(Tags.Blocks.SAND).addTags(new Tag.Named[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SAND_RED});
        this.m_126548_(Tags.Blocks.SAND_COLORLESS).m_126582_((Object)Blocks.f_49992_);
        this.m_126548_(Tags.Blocks.SAND_RED).m_126582_((Object)Blocks.f_49993_);
        this.m_126548_(Tags.Blocks.SANDSTONE).m_126584_((Object[])new Block[]{Blocks.f_50062_, Blocks.f_50064_, Blocks.f_50063_, Blocks.f_50471_, Blocks.f_50394_, Blocks.f_50396_, Blocks.f_50395_, Blocks.f_50473_});
        this.m_126548_(Tags.Blocks.STONE).m_126584_((Object[])new Block[]{Blocks.f_50334_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_50226_, Blocks.f_50069_, Blocks.f_50387_, Blocks.f_50281_, Blocks.f_50175_, Blocks.f_152550_, Blocks.f_152555_, Blocks.f_152596_, Blocks.f_152496_});
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS).addTags(new Tag.Named[]{Tags.Blocks.STORAGE_BLOCKS_AMETHYST, Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Blocks.STORAGE_BLOCKS_COPPER, Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Blocks.STORAGE_BLOCKS_NETHERITE});
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_AMETHYST).m_126582_((Object)Blocks.f_152490_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_COAL).m_126582_((Object)Blocks.f_50353_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_COPPER).m_126584_((Object[])new Block[]{Blocks.f_152504_, Blocks.f_152510_});
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_DIAMOND).m_126582_((Object)Blocks.f_50090_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_EMERALD).m_126582_((Object)Blocks.f_50268_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_GOLD).m_126582_((Object)Blocks.f_50074_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_IRON).m_126582_((Object)Blocks.f_50075_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_LAPIS).m_126582_((Object)Blocks.f_50060_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_QUARTZ).m_126582_((Object)Blocks.f_50333_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER).m_126582_((Object)Blocks.f_152599_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD).m_126582_((Object)Blocks.f_152600_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_RAW_IRON).m_126582_((Object)Blocks.f_152598_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE).m_126582_((Object)Blocks.f_50330_);
        this.m_126548_(Tags.Blocks.STORAGE_BLOCKS_NETHERITE).m_126582_((Object)Blocks.f_50721_);
    }

    private void addColored(Consumer<Block> consumer, Tag.Named<Block> group, String pattern) {
        String prefix = group.m_6979_().m_135815_().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.m_41065_()));
            Tag.Named<Block> tag = this.getForgeTag(prefix + color.m_41065_());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.f_50016_) {
                throw new IllegalStateException("Unknown vanilla block: " + key.toString());
            }
            this.m_126548_(tag).m_126582_((Object)block);
            consumer.accept(block);
        }
    }

    private Tag.Named<Block> getForgeTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (Tag.Named)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    public String m_6055_() {
        return "Forge Block Tags";
    }
}

