/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.IModLoadingState;
import net.minecraftforge.fml.IModStateProvider;
import net.minecraftforge.fml.IModStateTransition;
import net.minecraftforge.fml.ModLoadingPhase;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingState;
import net.minecraftforge.fml.ThreadSelector;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.ObjectHolderRegistry;

public class ForgeStatesProvider
implements IModStateProvider {
    final ModLoadingState CREATE_REGISTRIES = ModLoadingState.withTransition((String)"CREATE_REGISTRIES", (String)"CONSTRUCT", (ModLoadingPhase)ModLoadingPhase.GATHER, SerialTransition.of(() -> Stream.of(IModStateTransition.EventGenerator.fromFunction(RegistryEvent.NewRegistry::new))));
    final ModLoadingState OBJECT_HOLDERS = ModLoadingState.withInline((String)"OBJECT_HOLDERS", (String)"CREATE_REGISTRIES", (ModLoadingPhase)ModLoadingPhase.GATHER, ml -> ObjectHolderRegistry.findObjectHolders());
    final ModLoadingState INJECT_CAPABILITIES = ModLoadingState.withInline((String)"INJECT_CAPABILITIES", (String)"OBJECT_HOLDERS", (ModLoadingPhase)ModLoadingPhase.GATHER, ml -> CapabilityManager.INSTANCE.injectCapabilities(ml.getAllScanData()));
    final ModLoadingState CUSTOM_TAGS = ModLoadingState.withInline((String)"CUSTOM_TAGS", (String)"INJECT_CAPABILITIES", (ModLoadingPhase)ModLoadingPhase.GATHER, ml -> GameData.setCustomTagTypesFromRegistries());
    final ModLoadingState LOAD_REGISTRIES = ModLoadingState.withTransition((String)"LOAD_REGISTRIES", (String)"CUSTOM_TAGS", (ModLoadingPhase)ModLoadingPhase.GATHER, new SerialTransition(GameData::generateRegistryEvents, GameData::preRegistryEventDispatch, GameData::postRegistryEventDispatch, GameData::checkForRevertToVanilla));
    final ModLoadingState FREEZE = ModLoadingState.withInline((String)"FREEZE_DATA", (String)"COMPLETE", (ModLoadingPhase)ModLoadingPhase.COMPLETE, ml -> GameData.freezeData());
    final ModLoadingState NETLOCK = ModLoadingState.withInline((String)"NETWORK_LOCK", (String)"FREEZE_DATA", (ModLoadingPhase)ModLoadingPhase.COMPLETE, ml -> NetworkRegistry.lock());

    public List<IModLoadingState> getAllStates() {
        return List.of(this.CREATE_REGISTRIES, this.OBJECT_HOLDERS, this.INJECT_CAPABILITIES, this.CUSTOM_TAGS, this.LOAD_REGISTRIES, this.FREEZE, this.NETLOCK);
    }

    record SerialTransition<T extends Event>(Supplier<Stream<IModStateTransition.EventGenerator<?>>> eventStream, BiFunction<Executor, ? extends IModStateTransition.EventGenerator<T>, CompletableFuture<List<Throwable>>> preDispatchHook, BiFunction<Executor, ? extends IModStateTransition.EventGenerator<T>, CompletableFuture<List<Throwable>>> postDispatchHook, BiFunction<Executor, CompletableFuture<List<Throwable>>, CompletableFuture<List<Throwable>>> finalActivityGenerator) implements IModStateTransition
    {
        public static <T extends Event> SerialTransition<T> of(Supplier<Stream<IModStateTransition.EventGenerator<?>>> eventStream) {
            return new SerialTransition<T>(eventStream, (t, f) -> CompletableFuture.completedFuture(Collections.emptyList()), (t, f) -> CompletableFuture.completedFuture(Collections.emptyList()), (e, prev) -> prev.thenApplyAsync(Function.identity(), (Executor)e));
        }

        public Supplier<Stream<IModStateTransition.EventGenerator<?>>> eventFunctionStream() {
            return this.eventStream;
        }

        public ThreadSelector threadSelector() {
            return ThreadSelector.SYNC;
        }

        public BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextModLoadingStage() {
            return ModLoadingStage::currentState;
        }
    }
}

