/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class SeparatePerspectiveModel
implements IModelGeometry<SeparatePerspectiveModel> {
    private final BlockModel baseModel;
    private final ImmutableMap<ItemTransforms.TransformType, BlockModel> perspectives;

    public SeparatePerspectiveModel(BlockModel baseModel, ImmutableMap<ItemTransforms.TransformType, BlockModel> perspectives) {
        this.baseModel = baseModel;
        this.perspectives = perspectives;
    }

    @Override
    public net.minecraft.client.resources.model.BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new BakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), spriteGetter.apply(owner.resolveTexture("particle")), overrides, this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, owner.isSideLit()), (ImmutableMap<ItemTransforms.TransformType, net.minecraft.client.resources.model.BakedModel>)ImmutableMap.copyOf((Map)Maps.transformValues(this.perspectives, value -> value.m_111449_(bakery, value, spriteGetter, modelTransform, modelLocation, owner.isSideLit()))));
    }

    @Override
    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        textures.addAll(this.baseModel.m_5500_(modelGetter, missingTextureErrors));
        for (BlockModel model : this.perspectives.values()) {
            textures.addAll(model.m_5500_(modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public static class BakedModel
    implements net.minecraft.client.resources.model.BakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final net.minecraft.client.resources.model.BakedModel baseModel;
        private final ImmutableMap<ItemTransforms.TransformType, net.minecraft.client.resources.model.BakedModel> perspectives;

        public BakedModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, net.minecraft.client.resources.model.BakedModel baseModel, ImmutableMap<ItemTransforms.TransformType, net.minecraft.client.resources.model.BakedModel> perspectives) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.baseModel = baseModel;
            this.perspectives = perspectives;
        }

        public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return Collections.emptyList();
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public ItemTransforms m_7442_() {
            return ItemTransforms.f_111786_;
        }

        public net.minecraft.client.resources.model.BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
            if (this.perspectives.containsKey((Object)cameraTransformType)) {
                net.minecraft.client.resources.model.BakedModel p = (net.minecraft.client.resources.model.BakedModel)this.perspectives.get((Object)cameraTransformType);
                return p.handlePerspective(cameraTransformType, poseStack);
            }
            return this.baseModel.handlePerspective(cameraTransformType, poseStack);
        }
    }

    public static class Loader
    implements IModelLoader<SeparatePerspectiveModel> {
        public static final Loader INSTANCE = new Loader();
        public static final ImmutableBiMap<String, ItemTransforms.TransformType> PERSPECTIVES = ImmutableBiMap.builder().put((Object)"none", (Object)ItemTransforms.TransformType.NONE).put((Object)"third_person_left_hand", (Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).put((Object)"third_person_right_hand", (Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).put((Object)"first_person_left_hand", (Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).put((Object)"first_person_right_hand", (Object)ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).put((Object)"head", (Object)ItemTransforms.TransformType.HEAD).put((Object)"gui", (Object)ItemTransforms.TransformType.GUI).put((Object)"ground", (Object)ItemTransforms.TransformType.GROUND).put((Object)"fixed", (Object)ItemTransforms.TransformType.FIXED).build();

        public void m_6213_(ResourceManager p_10758_) {
        }

        @Override
        public SeparatePerspectiveModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"base"), BlockModel.class);
            JsonObject perspectiveData = GsonHelper.m_13930_((JsonObject)modelContents, (String)"perspectives");
            ImmutableMap.Builder perspectives = ImmutableMap.builder();
            for (Map.Entry perspective : PERSPECTIVES.entrySet()) {
                if (!perspectiveData.has((String)perspective.getKey())) continue;
                BlockModel perspectiveModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)perspectiveData, (String)((String)perspective.getKey())), BlockModel.class);
                perspectives.put((Object)((ItemTransforms.TransformType)perspective.getValue()), (Object)perspectiveModel);
            }
            return new SeparatePerspectiveModel(baseModel, (ImmutableMap<ItemTransforms.TransformType, BlockModel>)perspectives.build());
        }
    }
}

