/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.ClientCommandSourceStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCommandHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static CommandDispatcher<CommandSourceStack> commands = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ClientCommandHandler::handleClientPlayerLogin);
    }

    private static void handleClientPlayerLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        CommandDispatcher<SharedSuggestionProvider> suggestionDispatcher = ClientCommandHandler.mergeServerCommands((CommandDispatcher<SharedSuggestionProvider>)new CommandDispatcher());
        PacketListener packetListener = event.getConnection().m_129538_();
        if (packetListener instanceof ClientPacketListener) {
            ClientPacketListener listener = (ClientPacketListener)packetListener;
            listener.f_104899_ = suggestionDispatcher;
        }
    }

    public static CommandDispatcher<SharedSuggestionProvider> mergeServerCommands(CommandDispatcher<SharedSuggestionProvider> serverCommands) {
        CommandDispatcher commandsTemp = new CommandDispatcher();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterClientCommandsEvent((CommandDispatcher<CommandSourceStack>)commandsTemp));
        commands = new CommandDispatcher();
        ClientCommandHandler.copy(commandsTemp.getRoot(), commands.getRoot());
        RootCommandNode serverCommandsRoot = serverCommands.getRoot();
        CommandDispatcher newServerCommands = new CommandDispatcher();
        ClientCommandHandler.copy(serverCommandsRoot, newServerCommands.getRoot());
        RootCommandNode serverCommandsCopy = new RootCommandNode();
        ClientCommandHandler.mergeCommandNode(newServerCommands.getRoot(), serverCommandsCopy, new IdentityHashMap(), Minecraft.m_91087_().m_91403_().m_105137_(), context -> 0, suggestions -> null);
        ClientCommandHandler.mergeCommandNode(commands.getRoot(), newServerCommands.getRoot(), new IdentityHashMap(), ClientCommandHandler.getSource(), context -> 0, suggestions -> {
            SuggestionProvider suggestionProvider = SuggestionProviders.m_121664_((SuggestionProvider)suggestions);
            if (suggestionProvider == SuggestionProviders.f_121641_) {
                suggestionProvider = (context, builder) -> {
                    ClientCommandSourceStack source = ClientCommandHandler.getSource();
                    StringReader reader = new StringReader(context.getInput());
                    if (reader.canRead() && reader.peek() == '/') {
                        reader.skip();
                    }
                    ParseResults parse = commands.parse(reader, (Object)source);
                    return commands.getCompletionSuggestions(parse);
                };
            }
            return suggestionProvider;
        });
        ClientCommandHandler.mergeCommandNode(serverCommandsCopy, commands.getRoot(), new IdentityHashMap(), Minecraft.m_91087_().m_91403_().m_105137_(), context -> {
            Minecraft.m_91087_().f_91074_.m_108739_((context.getInput().startsWith("/") ? "" : "/") + context.getInput());
            return 0;
        }, suggestions -> null);
        return newServerCommands;
    }

    public static CommandDispatcher<CommandSourceStack> getDispatcher() {
        return commands;
    }

    public static ClientCommandSourceStack getSource() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return new ClientCommandSourceStack((CommandSource)player, player.m_20182_(), player.m_20155_(), player.m_8088_(), player.m_7755_().getString(), player.m_5446_(), (Entity)player);
    }

    private static <S> void copy(CommandNode<S> sourceNode, CommandNode<S> resultNode) {
        IdentityHashMap<Object, Object> newNodes = new IdentityHashMap<Object, Object>();
        newNodes.put(sourceNode, resultNode);
        for (CommandNode child : sourceNode.getChildren()) {
            CommandNode copy = newNodes.computeIfAbsent(child, innerChild -> {
                ArgumentBuilder builder = innerChild.createBuilder();
                CommandNode innerCopy = builder.build();
                ClientCommandHandler.copy(innerChild, innerCopy);
                return innerCopy;
            });
            resultNode.addChild(copy);
        }
    }

    private static <S, T> void mergeCommandNode(CommandNode<S> sourceNode, CommandNode<T> resultNode, Map<CommandNode<S>, CommandNode<T>> sourceToResult, S canUse, Command<T> execute, Function<SuggestionProvider<S>, SuggestionProvider<T>> sourceToResultSuggestion) {
        sourceToResult.put(sourceNode, resultNode);
        for (CommandNode sourceChild : sourceNode.getChildren()) {
            if (!sourceChild.canUse(canUse)) continue;
            resultNode.addChild(ClientCommandHandler.toResult(sourceChild, sourceToResult, canUse, execute, sourceToResultSuggestion));
        }
    }

    private static <S, T> CommandNode<T> toResult(CommandNode<S> sourceNode, Map<CommandNode<S>, CommandNode<T>> sourceToResult, S canUse, Command<T> execute, Function<SuggestionProvider<S>, SuggestionProvider<T>> sourceToResultSuggestion) {
        LiteralArgumentBuilder resultBuilder;
        if (sourceToResult.containsKey(sourceNode)) {
            return sourceToResult.get(sourceNode);
        }
        if (sourceNode instanceof ArgumentCommandNode) {
            ArgumentCommandNode sourceArgument = (ArgumentCommandNode)sourceNode;
            RequiredArgumentBuilder resultArgumentBuilder = RequiredArgumentBuilder.argument((String)sourceArgument.getName(), (ArgumentType)sourceArgument.getType());
            if (sourceArgument.getCustomSuggestions() != null) {
                resultArgumentBuilder.suggests(sourceToResultSuggestion.apply(sourceArgument.getCustomSuggestions()));
            }
            resultBuilder = resultArgumentBuilder;
        } else if (sourceNode instanceof LiteralCommandNode) {
            LiteralCommandNode sourceLiteral = (LiteralCommandNode)sourceNode;
            resultBuilder = LiteralArgumentBuilder.literal((String)sourceLiteral.getLiteral());
        } else {
            if (sourceNode instanceof RootCommandNode) {
                RootCommandNode resultNode = new RootCommandNode();
                ClientCommandHandler.mergeCommandNode(sourceNode, resultNode, sourceToResult, canUse, execute, sourceToResultSuggestion);
                return resultNode;
            }
            throw new IllegalStateException("Node type " + sourceNode + " is not a standard node type");
        }
        if (sourceNode.getCommand() != null) {
            resultBuilder.executes(execute);
        }
        if (sourceNode.getRedirect() != null) {
            resultBuilder.redirect(ClientCommandHandler.toResult(sourceNode.getRedirect(), sourceToResult, canUse, execute, sourceToResultSuggestion));
        }
        CommandNode resultNode = resultBuilder.build();
        ClientCommandHandler.mergeCommandNode(sourceNode, resultNode, sourceToResult, canUse, execute, sourceToResultSuggestion);
        return resultNode;
    }

    public static boolean sendMessage(String sendMessage) {
        StringReader reader = new StringReader(sendMessage);
        if (!reader.canRead() || reader.read() != '/') {
            return false;
        }
        ClientCommandSourceStack source = ClientCommandHandler.getSource();
        try {
            commands.execute(reader, (Object)source);
        }
        catch (CommandRuntimeException execution) {
            Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent("").m_7220_(execution.m_79226_()).m_130940_(ChatFormatting.RED), Util.f_137441_);
        }
        catch (CommandSyntaxException syntax) {
            if (syntax.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand()) {
                return false;
            }
            Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent("").m_7220_(ComponentUtils.m_130729_((Message)syntax.getRawMessage())).m_130940_(ChatFormatting.RED), Util.f_137441_);
            if (syntax.getInput() != null && syntax.getCursor() >= 0) {
                int position = Math.min(syntax.getInput().length(), syntax.getCursor());
                MutableComponent details = new TextComponent("").m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, reader.getString())));
                if (position > 10) {
                    details.m_130946_("...");
                }
                details.m_130946_(syntax.getInput().substring(Math.max(0, position - 10), position));
                if (position < syntax.getInput().length()) {
                    details.m_7220_((Component)new TextComponent(syntax.getInput().substring(position)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE}));
                }
                details.m_7220_((Component)new TranslatableComponent("command.context.here").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent("").m_7220_((Component)details).m_130940_(ChatFormatting.RED), Util.f_137441_);
            }
        }
        catch (Exception generic) {
            TextComponent message = new TextComponent(generic.getMessage() == null ? generic.getClass().getName() : generic.getMessage());
            Minecraft.m_91087_().f_91074_.m_6352_((Component)new TranslatableComponent("command.failed").m_130940_(ChatFormatting.RED).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)message))), Util.f_137441_);
            LOGGER.error("Error executing client command \"{}\"", (Object)sendMessage, (Object)generic);
        }
        return true;
    }
}

