/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.util;

import com.natamus.justmobheads.util.HeadData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Util {
    private static String dirpath = System.getProperty("user.dir") + File.separator + "config" + File.separator + "justmobheads";
    private static File dir = new File(dirpath);
    private static File file = new File(dirpath + File.separator + "headchances.txt");

    public static boolean generateChanceConfig(Map<String, Double> defaultchances) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        HeadData.headchances = new HashMap<String, Double>();
        PrintWriter writer = null;
        if (dir.isDirectory() && file.isFile()) {
            String[] cspl;
            String content = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "headchances.txt", new String[0])));
            for (String line : cspl = content.replaceAll("\n", "").split(",")) {
                String[] linespl = line.replace("\"", "").replaceAll(" ", "").trim().split(":");
                if (linespl.length < 2) continue;
                String mobname = linespl[0];
                Double chancevalue = 0.0;
                try {
                    chancevalue = Double.parseDouble(linespl[1]);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                HeadData.headchances.put(mobname, chancevalue);
            }
            ArrayList<String> appendkeys = new ArrayList<String>();
            ArrayList<String> defaultkeys = new ArrayList<String>(defaultchances.keySet());
            Collections.sort(defaultkeys);
            for (String mobname : defaultkeys) {
                if (HeadData.headchances.containsKey(mobname)) continue;
                appendkeys.add(mobname);
            }
            if (appendkeys.size() > 0) {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(dirpath + File.separator + "headchances.txt", true)));
                Collections.sort(appendkeys);
                for (String mobname : appendkeys) {
                    Double chancevalue = defaultchances.get(mobname);
                    writer.println("\"" + mobname + "\" : " + chancevalue + ",");
                    HeadData.headchances.put(mobname, chancevalue);
                }
                writer.close();
            }
            return true;
        }
        dir.mkdirs();
        writer = new PrintWriter(dirpath + File.separator + "headchances.txt", "UTF-8");
        if (writer != null) {
            ArrayList<String> defaultkeys = new ArrayList<String>(defaultchances.keySet());
            Collections.sort(defaultkeys);
            for (String mobname : defaultkeys) {
                Double chancevalue = defaultchances.get(mobname);
                writer.println("\"" + mobname + "\" : " + chancevalue + ",");
                HeadData.headchances.put(mobname, chancevalue);
            }
            writer.close();
        }
        return false;
    }
}

