/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.HeadFunctions;
import com.natamus.justmobheads.util.HeadData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MobHeads {
    static List<String> horsetypes = Arrays.asList("white", "creamy", "chestnut", "brown", "black", "gray", "dark_brown");
    static List<String> llamatypes = Arrays.asList("creamy", "white", "brown", "gray");
    static List<String> parrottypes = Arrays.asList("red", "blue", "green", "cyan", "gray");
    static List<String> rabbittypes = Arrays.asList("brown", "white", "black", "black_and_white", "gold", "salt_and_pepper");
    static List<String> cattypes = Arrays.asList("tabby", "tuxedo", "red", "siamese", "british_shorthair", "calico", "persian", "ragdoll", "white", "jellie", "black");
    static List<String> axolotltypes = Arrays.asList("lucy", "wild", "gold", "cyan", "blue");

    public static ItemStack getMobHead(String mobname, Integer amount) {
        Pair<String, String> mobdata = HeadData.headdata.get(mobname);
        if (mobdata == null) {
            return null;
        }
        String headname = MobHeads.capitalizeFirst(mobname.replace("_", " ")) + " Head";
        String oldid = (String)mobdata.getFirst();
        String texture = (String)mobdata.getSecond();
        ItemStack mobhead = HeadFunctions.getTexturedHead((String)headname, (String)texture, (String)oldid, (Integer)amount);
        return mobhead;
    }

    public static ItemStack getStandardHead(String headname) {
        ItemStack mobhead = new ItemStack((ItemLike)Items.f_42680_, 1);
        String mob = headname.toLowerCase().split(" ")[0];
        if (mob.equals("creeper")) {
            mobhead = new ItemStack((ItemLike)Items.f_42682_, 1);
        } else if (mob.equals("zombie")) {
            mobhead = new ItemStack((ItemLike)Items.f_42681_, 1);
        } else if (mob.equals("skeleton")) {
            mobhead = new ItemStack((ItemLike)Items.f_42678_, 1);
        }
        mobhead.m_41714_((Component)new TextComponent(headname));
        return mobhead;
    }

    public static String getName(Entity entity) {
        ZombieVillager zombievillager;
        VillagerData d;
        VillagerProfession prof;
        String entitystring = EntityFunctions.getEntityString((Entity)entity);
        Object mobname = entitystring.split("\\[")[0].replace("Entity", "");
        mobname = String.join((CharSequence)"_", ((String)mobname).split("(?<=.)(?=\\p{Lu})")).toLowerCase();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (creeper.m_7090_()) {
                mobname = "charged_creeper";
            }
        } else if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            Integer type = cat.m_28163_();
            if (type < cattypes.size()) {
                mobname = cattypes.get(type) + "_cat";
            }
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            CompoundTag nbt = horse.serializeNBT();
            Integer type = nbt.m_128451_("Variant");
            if (type >= 1024) {
                type = type - 1024;
            } else if (type >= 768) {
                type = type - 768;
            } else if (type >= 512) {
                type = type - 512;
            } else if (type >= 256) {
                type = type - 256;
            }
            mobname = horsetypes.get(type) + "_horse";
        } else if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            Integer type = llama.m_30825_();
            if (type < llamatypes.size()) {
                mobname = llamatypes.get(type) + "_" + (String)mobname;
            }
        } else if (entity instanceof TraderLlama) {
            TraderLlama traderllama = (TraderLlama)entity;
            Integer type = traderllama.m_30825_();
            if (type < llamatypes.size()) {
                mobname = llamatypes.get(type) + "_trader_" + (String)mobname;
            }
        } else if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            Integer type = parrot.m_29440_();
            if (type < parrottypes.size()) {
                mobname = parrottypes.get(type) + "_parrot";
            }
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            Integer type = rabbit.m_29719_();
            if (type < rabbittypes.size()) {
                mobname = rabbittypes.get(type) + "_rabbit";
            } else if (type == 99) {
                mobname = "killer_rabbit";
            }
        } else if (entity instanceof Sheep) {
            String name;
            Sheep sheep = (Sheep)entity;
            boolean checktype = true;
            if (sheep.m_8077_() && (name = sheep.m_7755_().getString()).equals("jeb_")) {
                mobname = "jeb_sheep";
                checktype = false;
            }
            if (checktype) {
                DyeColor type = sheep.m_29874_();
                mobname = type.toString().toLowerCase() + "_sheep";
            }
        } else if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            if (mooshroom.m_28955_() == MushroomCow.MushroomType.BROWN) {
                mobname = "brown_mooshroom";
            }
        } else if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            Integer type = axolotl.m_149179_().m_149242_();
            if (type < axolotltypes.size()) {
                mobname = axolotltypes.get(type) + "_axolotl";
            }
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            VillagerData d2 = villager.m_7141_();
            VillagerProfession prof2 = d2.m_35571_();
            if (prof2.toString() != "none") {
                mobname = prof2.toString();
            }
        } else if (entity instanceof ZombieVillager && (prof = (d = (zombievillager = (ZombieVillager)entity).m_7141_()).m_35571_()).toString() != "none") {
            mobname = "zombie_" + prof.toString();
        }
        return ((String)mobname).toLowerCase();
    }

    public static String capitalizeFirst(String string) {
        StringBuffer sb = new StringBuffer(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }
}

