/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.events;

import com.mojang.authlib.GameProfile;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.justmobheads.config.ConfigHandler;
import com.natamus.justmobheads.util.HeadData;
import com.natamus.justmobheads.util.MobHeads;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HeadDropEvent {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void mobItemDrop(LivingDropsEvent e) {
        ItemEntity mobhead;
        Integer looting;
        TamableAnimal te;
        Entity entity = e.getEntity();
        Level world = entity.m_20193_();
        if (world.f_46443_) {
            return;
        }
        if (((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByChargedCreeper.get()).booleanValue() || ((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByPlayerKill.get()).booleanValue()) {
            DamageSource source = e.getSource();
            Entity sourceentity = source.m_7640_();
            if (((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByChargedCreeper.get()).booleanValue()) {
                if (!(sourceentity instanceof Creeper)) return;
                Creeper creeper = (Creeper)sourceentity;
                if (!creeper.m_7090_()) {
                    return;
                }
            } else if (((Boolean)ConfigHandler.GENERAL.onlyDropHeadsByPlayerKill.get()).booleanValue() && !(sourceentity instanceof Player)) {
                return;
            }
        }
        if (((Boolean)ConfigHandler.GENERAL.onlyAdultMobsDropTheirHead.get()).booleanValue() && entity instanceof TamableAnimal && (te = (TamableAnimal)entity).m_6162_()) {
            return;
        }
        String mobname = MobHeads.getName(entity);
        if (mobname == "") {
            return;
        }
        double extrachance = 0.0;
        if (((Boolean)ConfigHandler.GENERAL.enableLootingEnchant.get()).booleanValue() && (looting = Integer.valueOf(e.getLootingLevel())) > 0) {
            extrachance = 0.025 + (double)(looting / 100);
        }
        Object headname = "";
        if (mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton")) {
            if (!((Boolean)ConfigHandler.GENERAL.enableStandardHeads.get()).booleanValue()) return;
            headname = mobname.substring(0, 1).toUpperCase() + mobname.substring(1) + " Head";
        }
        double num = Math.random();
        if (((Boolean)ConfigHandler.GENERAL.mobSpecificDropChances.get()).booleanValue()) {
            double chance = -1.0;
            if (((String)headname).equals("")) {
                if (HeadData.headchances.containsKey(mobname)) {
                    chance = HeadData.headchances.get(mobname);
                }
            } else {
                chance = (Double)ConfigHandler.GENERAL.creeperSkeletonZombieDropChance.get();
            }
            if (chance == -1.0 ? num > (Double)ConfigHandler.GENERAL.overallDropChance.get() + extrachance : num > chance + extrachance) {
                return;
            }
        } else if (num > (Double)ConfigHandler.GENERAL.overallDropChance.get() + extrachance) {
            return;
        }
        BlockPos pos = entity.m_142538_();
        if (((String)headname).equals("")) {
            ItemStack headstack = MobHeads.getMobHead(mobname, 1);
            if (headstack == null) {
                return;
            }
            mobhead = new ItemEntity(world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), headstack);
        } else {
            mobhead = new ItemEntity(world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), MobHeads.getStandardHead((String)headname));
        }
        world.m_7967_((Entity)mobhead);
    }

    @SubscribeEvent
    public void onPlayerHeadBreak(BlockEvent.BreakEvent e) {
        Level world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getWorld());
        if (world == null) {
            return;
        }
        BlockState state = e.getState();
        Block block = state.m_60734_();
        if (block instanceof SkullBlock || block instanceof WallSkullBlock) {
            ItemStack named_headstack;
            if (e.getPlayer().m_7500_()) {
                return;
            }
            BlockPos pos = e.getPos();
            SkullBlockEntity sbe = (SkullBlockEntity)world.m_7702_(pos);
            if (sbe == null) {
                return;
            }
            GameProfile profile = sbe.m_59779_();
            if (profile == null) {
                return;
            }
            UUID uuid = profile.getId();
            if (uuid == null) {
                return;
            }
            String headid = uuid.toString();
            String correctheadname = "";
            for (String headname : HeadData.headdata.keySet()) {
                String headnameid = (String)HeadData.headdata.get(headname).getFirst();
                if (!headid.equals(headnameid)) continue;
                correctheadname = headname;
                break;
            }
            if ((named_headstack = MobHeads.getMobHead(correctheadname, 1)) != null) {
                e.setCanceled(true);
                world.m_46961_(pos, false);
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), named_headstack));
            }
        }
    }
}

