/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.internal.ForgeTransmogrifier;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class ForgeAdapter {
    private ForgeAdapter() {
    }

    public static World adapt(ServerLevel world) {
        return new ForgeWorld(world);
    }

    public static ServerLevel adapt(World world) {
        Preconditions.checkNotNull((Object)world);
        if (world instanceof ForgeWorld) {
            return ((ForgeWorld)world).getWorld();
        }
        throw new UnsupportedOperationException("Cannot adapt from a " + world.getClass());
    }

    public static Biome adapt(BiomeType biomeType) {
        return (Biome)ServerLifecycleHooks.getCurrentServer().m_129911_().m_175515_(Registry.f_122885_).m_6612_(new ResourceLocation(biomeType.getId())).orElseThrow(() -> new IllegalStateException("No biome for " + biomeType.getId()));
    }

    public static BiomeType adapt(Biome biome) {
        ResourceLocation id = ServerLifecycleHooks.getCurrentServer().m_129911_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
        Objects.requireNonNull(id, "biome is not registered");
        return BiomeTypes.get(id.toString());
    }

    public static Vector3 adapt(Vec3 vector) {
        return Vector3.at(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public static BlockVector3 adapt(BlockPos pos) {
        return BlockVector3.at(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static Vec3 toVec3(BlockVector3 vector) {
        return new Vec3((double)vector.getBlockX(), (double)vector.getBlockY(), (double)vector.getBlockZ());
    }

    public static Direction adapt(com.sk89q.worldedit.util.Direction face) {
        switch (face) {
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.EAST;
            }
            case DOWN: {
                return Direction.DOWN;
            }
        }
        return Direction.UP;
    }

    public static com.sk89q.worldedit.util.Direction adaptEnumFacing(@Nullable Direction face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case NORTH: {
                return com.sk89q.worldedit.util.Direction.NORTH;
            }
            case SOUTH: {
                return com.sk89q.worldedit.util.Direction.SOUTH;
            }
            case WEST: {
                return com.sk89q.worldedit.util.Direction.WEST;
            }
            case EAST: {
                return com.sk89q.worldedit.util.Direction.EAST;
            }
            case DOWN: {
                return com.sk89q.worldedit.util.Direction.DOWN;
            }
        }
        return com.sk89q.worldedit.util.Direction.UP;
    }

    public static BlockPos toBlockPos(BlockVector3 vector) {
        return new BlockPos(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Deprecated
    public static Property<?> adaptProperty(net.minecraft.world.level.block.state.properties.Property<?> property) {
        return ForgeTransmogrifier.transmogToWorldEditProperty(property);
    }

    @Deprecated
    public static Map<Property<?>, Object> adaptProperties(BlockType block, Map<net.minecraft.world.level.block.state.properties.Property<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(Property::getName));
        for (Map.Entry<net.minecraft.world.level.block.state.properties.Property<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof DirectionProperty) {
                value = ForgeAdapter.adaptEnumFacing((Direction)value);
            } else if (prop.getKey() instanceof EnumProperty) {
                value = ((StringRepresentable)value).m_7912_();
            }
            props.put(block.getProperty(prop.getKey().m_61708_()), value);
        }
        return props;
    }

    public static BlockState adapt(com.sk89q.worldedit.world.block.BlockState blockState) {
        int blockStateId = BlockStateIdAccess.getBlockStateId(blockState);
        if (!BlockStateIdAccess.isValidInternalId(blockStateId)) {
            return ForgeTransmogrifier.transmogToMinecraft(blockState);
        }
        return Block.m_49803_((int)blockStateId);
    }

    public static com.sk89q.worldedit.world.block.BlockState adapt(BlockState blockState) {
        int blockStateId = Block.m_49956_((BlockState)blockState);
        com.sk89q.worldedit.world.block.BlockState worldEdit = BlockStateIdAccess.getBlockStateById(blockStateId);
        if (worldEdit == null) {
            return ForgeTransmogrifier.transmogToWorldEdit(blockState);
        }
        return worldEdit;
    }

    public static Block adapt(BlockType blockType) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockType.getId()));
    }

    public static BlockType adapt(Block block) {
        return BlockTypes.get(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
    }

    public static Item adapt(ItemType itemType) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemType.getId()));
    }

    public static ItemType adapt(Item item) {
        return ItemTypes.get(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString());
    }

    public static ItemStack adapt(BaseItemStack baseItemStack) {
        CompoundTag forgeCompound = null;
        if (baseItemStack.getNbtData() != null) {
            forgeCompound = NBTConverter.toNative(baseItemStack.getNbtData());
        }
        ItemStack itemStack = new ItemStack((ItemLike)ForgeAdapter.adapt(baseItemStack.getType()), baseItemStack.getAmount());
        itemStack.m_41751_(forgeCompound);
        return itemStack;
    }

    public static BaseItemStack adapt(ItemStack itemStack) {
        Tag tagTag;
        com.sk89q.jnbt.CompoundTag tag = NBTConverter.fromNative(itemStack.serializeNBT());
        tag = tag.getValue().isEmpty() ? null : ((tagTag = (Tag)tag.getValue().get("tag")) instanceof com.sk89q.jnbt.CompoundTag ? (com.sk89q.jnbt.CompoundTag)tagTag : null);
        return new BaseItemStack(ForgeAdapter.adapt(itemStack.m_41720_()), tag, itemStack.m_41613_());
    }

    public static ForgePlayer adaptPlayer(ServerPlayer player) {
        Preconditions.checkNotNull((Object)player);
        return new ForgePlayer(player);
    }
}

