/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.event.platform.PlatformUnreadyEvent;
import com.sk89q.worldedit.event.platform.PlatformsRegisteredEvent;
import com.sk89q.worldedit.event.platform.SessionIdleEvent;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.fabric.CommandWrapper;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricConfiguration;
import com.sk89q.worldedit.fabric.FabricPermissionsProvider;
import com.sk89q.worldedit.fabric.FabricPlatform;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.fabric.FabricWorld;
import com.sk89q.worldedit.fabric.ThreadSafeCache;
import com.sk89q.worldedit.fabric.net.handler.WECUIPacketHandler;
import com.sk89q.worldedit.internal.anvil.ChunkDeleter;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.lifecycle.Lifecycled;
import com.sk89q.worldedit.util.lifecycle.SimpleLifecycled;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import org.enginehub.piston.Command;

public class FabricWorldEdit
implements ModInitializer {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    public static final String MOD_ID = "worldedit";
    public static final String CUI_PLUGIN_CHANNEL = "cui";
    public static final Lifecycled<MinecraftServer> LIFECYCLED_SERVER;
    private FabricPermissionsProvider provider;
    public static FabricWorldEdit inst;
    private FabricPlatform platform;
    private FabricConfiguration config;
    private Path workingDir;
    private ModContainer container;

    public FabricWorldEdit() {
        inst = this;
    }

    public void onInitialize() {
        this.container = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(() -> new IllegalStateException("WorldEdit mod missing in Fabric"));
        this.workingDir = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
        if (!Files.exists(this.workingDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.workingDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.platform = new FabricPlatform(this);
        WorldEdit.getInstance().getPlatformManager().register(this.platform);
        this.config = new FabricConfiguration(this);
        this.provider = this.getInitialPermissionsProvider();
        WECUIPacketHandler.init();
        ServerTickEvents.END_SERVER_TICK.register((Object)ThreadSafeCache.getInstance());
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        ServerLifecycleEvents.SERVER_STARTING.register(this::onStartingServer);
        ServerLifecycleEvents.SERVER_STARTED.register(this::onStartServer);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onStopServer);
        ServerPlayConnectionEvents.DISCONNECT.register(this::onPlayerDisconnect);
        AttackBlockCallback.EVENT.register(this::onLeftClickBlock);
        UseBlockCallback.EVENT.register(this::onRightClickBlock);
        UseItemCallback.EVENT.register(this::onRightClickAir);
        LOGGER.info("WorldEdit for Fabric (version " + this.getInternalVersion() + ") is loaded");
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        WorldEdit.getInstance().getEventBus().post(new PlatformsRegisteredEvent());
        PlatformManager manager = WorldEdit.getInstance().getPlatformManager();
        Platform commandsPlatform = manager.queryCapability(Capability.USER_COMMANDS);
        if (commandsPlatform != this.platform || !this.platform.isHookingEvents()) {
            return;
        }
        List commands = manager.getPlatformCommandManager().getCommandManager().getAllCommands().collect(Collectors.toList());
        for (Command command : commands) {
            CommandWrapper.register(dispatcher, command);
            Set perms = command.getCondition().as(PermissionCondition.class).map(PermissionCondition::getPermissions).orElseGet(Collections::emptySet);
            if (perms.isEmpty()) continue;
            perms.forEach(this.getPermissionsProvider()::registerPermission);
        }
    }

    private FabricPermissionsProvider getInitialPermissionsProvider() {
        try {
            Class.forName("me.lucko.fabric.api.permissions.v0.Permissions", false, this.getClass().getClassLoader());
            return new FabricPermissionsProvider.LuckoFabricPermissionsProvider(this.platform);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new FabricPermissionsProvider.VanillaPermissionsProvider(this.platform);
        }
    }

    private void setupRegistries(MinecraftServer server) {
        for (class_2960 name : class_2378.field_11146.method_10235()) {
            if (BlockType.REGISTRY.get(name.toString()) != null) continue;
            BlockType.REGISTRY.register(name.toString(), new BlockType(name.toString(), input -> FabricAdapter.adapt(FabricAdapter.adapt(input.getBlockType()).method_9564())));
        }
        for (class_2960 name : class_2378.field_11142.method_10235()) {
            if (ItemType.REGISTRY.get(name.toString()) != null) continue;
            ItemType.REGISTRY.register(name.toString(), new ItemType(name.toString()));
        }
        for (class_2960 name : class_2378.field_11145.method_10235()) {
            if (EntityType.REGISTRY.get(name.toString()) != null) continue;
            EntityType.REGISTRY.register(name.toString(), new EntityType(name.toString()));
        }
        for (class_2960 name : server.method_30611().method_30530(class_2378.field_25114).method_10235()) {
            if (BiomeType.REGISTRY.get(name.toString()) != null) continue;
            BiomeType.REGISTRY.register(name.toString(), new BiomeType(name.toString()));
        }
        for (class_2960 name : class_3481.method_15073().method_30211()) {
            if (BlockCategory.REGISTRY.get(name.toString()) != null) continue;
            BlockCategory.REGISTRY.register(name.toString(), new BlockCategory(name.toString()));
        }
        for (class_2960 name : class_3489.method_15106().method_30211()) {
            if (ItemCategory.REGISTRY.get(name.toString()) != null) continue;
            ItemCategory.REGISTRY.register(name.toString(), new ItemCategory(name.toString()));
        }
    }

    private void onStartingServer(MinecraftServer minecraftServer) {
        Path delChunks = this.workingDir.resolve("delete_chunks.json");
        if (Files.exists(delChunks, new LinkOption[0])) {
            ChunkDeleter.runFromFile(delChunks, true);
        }
    }

    private void onStartServer(MinecraftServer minecraftServer) {
        this.setupRegistries(minecraftServer);
        this.config.load();
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent(this.platform));
    }

    private void onStopServer(MinecraftServer minecraftServer) {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        WorldEdit.getInstance().getEventBus().post(new PlatformUnreadyEvent(this.platform));
    }

    private boolean shouldSkip() {
        if (this.platform == null) {
            return true;
        }
        return !this.platform.isHookingEvents();
    }

    private class_1269 onLeftClickBlock(class_1657 playerEntity, class_1937 world, class_1268 hand, class_2338 blockPos, class_2350 direction) {
        Direction weDirection;
        FabricWorld localWorld;
        Location pos;
        FabricPlayer player;
        if (this.shouldSkip() || hand == class_1268.field_5810 || world.field_9236) {
            return class_1269.field_5811;
        }
        WorldEdit we = WorldEdit.getInstance();
        if (we.handleBlockLeftClick(player = FabricAdapter.adaptPlayer((class_3222)playerEntity), pos = new Location((Extent)(localWorld = this.getWorld(world)), blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), weDirection = FabricAdapter.adaptEnumFacing(direction))) {
            return class_1269.field_5812;
        }
        if (we.handleArmSwing(player)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1269 onRightClickBlock(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        Direction direction;
        FabricWorld localWorld;
        Location pos;
        FabricPlayer player;
        if (this.shouldSkip() || hand == class_1268.field_5810 || world.field_9236) {
            return class_1269.field_5811;
        }
        WorldEdit we = WorldEdit.getInstance();
        if (we.handleBlockRightClick(player = FabricAdapter.adaptPlayer((class_3222)playerEntity), pos = new Location((Extent)(localWorld = this.getWorld(world)), blockHitResult.method_17777().method_10263(), (double)blockHitResult.method_17777().method_10264(), (double)blockHitResult.method_17777().method_10260()), direction = FabricAdapter.adaptEnumFacing(blockHitResult.method_17780()))) {
            return class_1269.field_5812;
        }
        if (we.handleRightClick(player)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1271<class_1799> onRightClickAir(class_1657 playerEntity, class_1937 world, class_1268 hand) {
        FabricPlayer player;
        class_1799 stackInHand = playerEntity.method_5998(hand);
        if (this.shouldSkip() || hand == class_1268.field_5810 || world.field_9236) {
            return class_1271.method_22430((Object)stackInHand);
        }
        WorldEdit we = WorldEdit.getInstance();
        if (we.handleRightClick(player = FabricAdapter.adaptPlayer((class_3222)playerEntity))) {
            return class_1271.method_22427((Object)stackInHand);
        }
        return class_1271.method_22430((Object)stackInHand);
    }

    private void onPlayerDisconnect(class_3244 handler, MinecraftServer server) {
        WorldEdit.getInstance().getEventBus().post(new SessionIdleEvent(new FabricPlayer.SessionKeyImpl(handler.field_14140)));
    }

    FabricConfiguration getConfig() {
        return this.config;
    }

    public LocalSession getSession(class_3222 player) {
        Preconditions.checkNotNull((Object)player);
        return WorldEdit.getInstance().getSessionManager().get(FabricAdapter.adaptPlayer(player));
    }

    public FabricWorld getWorld(class_1937 world) {
        Preconditions.checkNotNull((Object)world);
        return new FabricWorld(world);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Path getWorkingDir() {
        return this.workingDir;
    }

    String getInternalVersion() {
        return this.container.getMetadata().getVersion().getFriendlyString();
    }

    public void setPermissionsProvider(FabricPermissionsProvider provider) {
        this.provider = provider;
    }

    public FabricPermissionsProvider getPermissionsProvider() {
        return this.provider;
    }

    static {
        SimpleLifecycled<MinecraftServer> lifecycledServer = SimpleLifecycled.invalid();
        ServerLifecycleEvents.SERVER_STARTED.register(lifecycledServer::newValue);
        ServerLifecycleEvents.SERVER_STOPPING.register(__ -> lifecycledServer.invalidate());
        LIFECYCLED_SERVER = lifecycledServer;
    }
}

